package cn.com.duiba.kjy.api.api.remoteservice.base;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.OfficialAccountDto;

/**
 * Created by dugq on 2020-02-03.
 */
@AdvancedFeignClient
public interface RemoteAccessTokenService {

    /**
     * 根据oaID获取access_token
     * @param oaId 公众号ID
     * @return  access_token
     */
    String getAccessTokenByOaId(Long oaId);

    /**
     * 根据appID获取access_token
     * @param appId 公众号appId
     * @return  access_token
     */
    String getAccessTokenByAppId(String appId);


    /**
     * 刷新accessToken 并返回最新的token
     * @param oaId 公众号ID
     * @return
     */
    String refreshAccessToken(Long oaId);


}
