package cn.com.duiba.kjy.api.api.remoteservice.wechat;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.wechat.KeywordDto;
import cn.com.duiba.kjy.api.api.dto.wechat.SubCatInfoDataDto;
import cn.com.duiba.kjy.api.api.dto.wechat.TemplateMsgListDataDto;
import cn.com.duiba.kjy.api.api.dto.wechat.TemplateTitleListDto;
import cn.com.duiba.kjy.api.api.param.wechat.SendSubscribeMessageRequestParam;
import cn.com.duiba.kjy.api.api.param.wechat.TemplateAddParam;
import me.chanjar.weixin.common.exception.WxErrorException;

import java.util.List;

/**
 * 微信小程序订阅消息设置api
 *
 * @Author xujing
 * @Date 2021/1/26 1:46 下午
 */
@AdvancedFeignClient
public interface RemoteWechatMiniSubscribeService {

    /**
     * 获取账号所设置的类目信息
     */
    List<SubCatInfoDataDto> subGetBean(String appId) throws BizException;

    /**
     * 获取模板标题列表
     */
    TemplateTitleListDto getPubTemplateTitles(String appId, String ids, Integer start, Integer limit) throws BizException;

    /**
     * 获取模板库某个模板标题下关键词库
     */
    List<KeywordDto> templateLibraryGet(String appId, String id) throws BizException;

    /**
     * 组合模板并添加至帐号下的个人模板库
     */
    Boolean templateAdd(TemplateAddParam templateAddParam) throws BizException;


    /**
     * 删除帐号下的某个模板
     */
    Boolean templateDel(String appId, String templateId) throws BizException;

    /**
     * 获取帐号下已存在的模板列表
     *
     * @param appId
     * @return
     */
    List<TemplateMsgListDataDto> templateGetList(String appId) throws BizException;


    /**
     * 发送模板消息
     *
     * @return
     * @see
     */
    Boolean sendSubscribeMessage(SendSubscribeMessageRequestParam sendSubscribeMessageRequestParam) throws BizException;
}
