package cn.com.duiba.kjy.api.api.remoteservice.wx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.wechat.WxAuthorizerDto;
import cn.com.duiba.kjy.api.api.param.wechat.AuthorizerSearchParam;

import java.util.List;

/**
 * @Author xujing
 * @Date 2021/2/19 10:47 上午
 */
@AdvancedFeignClient
public interface RemoteWxAuthorizerService {

    /**
     * 根据appId获取已授权的小程序信息
     * @param appId
     * @return
     */
    WxAuthorizerDto findAuthoredByAppId(String appId);

    /**
     * 分页查询
     * @param authorizerSearchParam
     * @return
     */
    List<WxAuthorizerDto> listByPage(AuthorizerSearchParam authorizerSearchParam);

    /**
     * 查询数量
     * @param authorizerSearchParam
     * @return
     */
    Long selectCount(AuthorizerSearchParam authorizerSearchParam);

    /**
     * 根据id获取已授权的小程序信息
     * @param id
     * @return
     */
    WxAuthorizerDto findById(Long id);

    /**
     * 根据userName查询小程序信息
     */

    WxAuthorizerDto selectByUserName(String userName);
}
