package cn.com.duiba.kjy.api.api.dto.wechat;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 授权微信公众账号和小程序基本信息
 * @Author xujing
 * @Date 2021/1/25 7:46 下午
 */
@Data
public class WxAuthorizerDto implements Serializable {


    private static final long serialVersionUID = -4600541473814793132L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 微信公众号appid
     */
    private String appId;

    /**
     * 授权账号类型，0代表公众号，1代表小程序
     */
    private Integer authorizerType;

    /**
     * 公众号类型，0代表订阅号，1代表由历史老帐号升级后的订阅号，2代表服务号 小程序类型 0普通小程序 12试用小程序 4小游戏 10小商店
     */
    private Integer serviceTypeInfo;

    /**
     * 授权方认证类型，-1代表未认证，0代表微信认证，1代表新浪微博认证，2代表腾讯微博认证，3代表已资质认证通过但还未通过名称认证，4代表已资质认证通过、还未通过名称认证，但通过了新浪微博认证，5代表已资质认证通过、还未通过名称认证，但通过了腾讯微博认证
     */
    private Integer verifyTypeInfo;

    /**
     * 公众号名称
     */
    private String nickName;

    /**
     * 公众号原始id
     */
    private String userName;

    /**
     * 公众号的主体名称
     */
    private String principalName;

    /**
     * 授权方头像
     */
    private String headImg;

    /**
     * 授权方公众号所设置的微信号，可能为空
     */
    private String alias;

    /**
     * 二维码图片的URL，开发者最好自行也进行保存
     */
    private String qrcodeUrl;

    /**
     * 授权状态,0为已授权,1为已取消授权
     */
    private Integer authorizationStatus;

    /**
     * 公众号的功能开通状况
     */
    private String businessInfo;

    /**
     * 公众号的权限集
     */
    private String funcInfo;

    /**
     * 是否删除0未删除;1已删除
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 公众号状态  0未投放 1 投放中 2托管 3运营中
     */
    private Integer serviceStatus;

    /**
     * 管理员姓名
     */
    private String managerName;

    /**
     * 小程序类型 0用户端 1管理端
     */
    private Integer appType;
}