package cn.com.duiba.kjy.api.api.remoteservice.wechat;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.wechat.WxAuthorizerTemplateDto;
import cn.com.duiba.kjy.api.api.dto.wechat.WxMpXmlMessageDto;

import java.util.List;

/**
 * 微信小程序代码管理api
 * @Author xujing
 * @Date 2021/1/26 11:29 上午
 */
@AdvancedFeignClient
public interface RemoteWechatMiniCodeManageService {

    /**
     * 为授权的小程序帐号上传小程序代码
     * @param templateId
     * @param appId
     * @return
     */
    boolean commit(Long templateId,String appId) throws BizException;

    /**
     * 提交审核
     * @param appId
     * @return
     */
    boolean submitAudit(String appId) throws BizException;

    /**
     * 手动刷新审核状态
     * @param appId
     */
    void updateAuditstatus(String appId) throws BizException;

    /**
     * 发布审核通过的版本
     * @param appId
     */
    void release(String appId) throws BizException;

    /**
     * 撤回审核
     * @param appId
     */
    void undocodeaudit(String appId) throws BizException;


    /**
     * 审核版本
     * @param appId
     * @return
     */
    WxAuthorizerTemplateDto selectAuditByAppId(String appId);

    /**
     * 线上版本
     * @param appId
     * @return
     */
    WxAuthorizerTemplateDto selectOnlineByAppId(String appId);

    /**
     * 历史版本
     * @param appId
     * @return
     */
    List<WxAuthorizerTemplateDto> selectHistoryByAppId(String appId);


    /**
     * 获取体验版二维码
     * @param appId
     * @return
     */
    String getQrCode(String appId,String path) throws BizException;



    /**
     * 加急审核
     * @param appId
     * @return
     */
    Boolean speedAudit(String appId, Integer auditid) throws BizException;

    /**
     * 更新审核状态
     * @return
     */
    Boolean updateAuditstatusByCallBack(WxMpXmlMessageDto wxMpXmlMessageDto);
}
