package cn.com.duiba.kjy.api.api.remoteservice.wechat;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.api.dto.wechat.SessionDto;
import cn.com.duiba.kjy.api.api.dto.wechat.WxAuthorizerDto;
import cn.com.duiba.kjy.api.api.dto.wechat.WxMpXmlMessageDto;
import cn.com.duiba.kjy.api.api.enums.wechat.AppTypeEnum;
import me.chanjar.weixin.common.exception.WxErrorException;

/**
 * wx第三方平台接口调用
 *
 * @Author xujing
 * @Date 2021/1/25 6:32 下午
 */
@AdvancedFeignClient
public interface RemoteWechatThirdPartyService {
    /**
     * 授权回调
     *
     * @param authCode
     * @param appType 0用户端 1管理端
     * @throws BizException
     */
    WxAuthorizerDto authorize(String authCode, AppTypeEnum appType) throws BizException;

    /**
     * 获得授权url
     * 0用户端 1管理端
     * @return
     */
    String getAuthorization(AppTypeEnum appType) throws BizException;

    /**
     * 接收微信推送 ticket
     *
     * @param xmlStr
     * @param msgSingnatrue
     * @param timestamp
     * @param nonce
     */
    void receiveTicket(String xmlStr, String msgSingnatrue, String timestamp, String nonce) throws BizException;


    /**
     * 小程序登陆code换sessionkey
     *
     * @param appid 小程序appid
     * @param code  登录时获取的 code
     * @return
     */
    SessionDto jscode2session(String appid, String code) throws BizException;


    /**
     * 解密微信推送消息
     *
     * @param xml
     * @param msgSingnatrue
     * @param timestamp
     * @param nonce
     * @param appid
     */
    WxMpXmlMessageDto decryptionMsg(String xml, String msgSingnatrue, String timestamp, String nonce, String appid);


    /**
     * 获取授权方token
     *
     * @param authorizerAppid
     * @return
     */
    String getAuthorizerAccessToken(String authorizerAppid) throws Exception;

}
