package cn.com.duiba.duiba.qutui.center.api.dto.task;

import cn.com.duiba.duiba.qutui.center.api.enums.EventLogStatusEnum;
import cn.com.duiba.duiba.qutui.center.api.util.MathUtil;
import cn.com.duiba.wolf.utils.BeanUtils;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName StaffEventGradeDto.java
 * @Description TODO
 * @createTime 2021年03月23日 13:32:00
 */
@Data
public class EventGradeDto implements Serializable {
    /**
     * 业绩说明
     */
    private String gradeExplain;

    /**
     * 事件显示名称
     */
    private String eventTxt;
    /**
     * 事件id
     */
    private Long eventId;
    /**
     * 事件总分
     */
    private Double eventGrade;

    /**
     * 是否统计参与人数
     */
    private Boolean joinPeopleNum = false;
    private String joinPeopleNumText;
    private Integer joinPeopleNumCount = 0;
    /**
     * 是否统计参与次数
     */
    private Boolean joinNum = false;
    private String joinNumText;
    private Integer joinNumCount = 0;
    /**
     * 是否统计完成人数
     */
    private Boolean finishJoinPeopleNum = false;
    private String finishJoinPeopleNumText;
    private Integer finishJoinPeopleNumCount = 0;
    /**
     * 是否统计完成次数
     */
    private Boolean finishJoinNum = false;
    private String finishJoinNumText;
    private Integer finishJoinNumCount = 0;

    /**
     * 是否统计自然流量
     */
    private Boolean isStatistical;
    private String statisticalText;
    private Integer statisticalCount = 0;

    public static EventGradeDto buildGrade(List<StaffEventGradeDto> staffEventGrades,
                                           Map<Long, Integer> eventId2StatisticalCount,
                                           Map<Long, ProjectEventDto> eventId2Dto) {
        if (CollectionUtils.isEmpty(staffEventGrades)) {
            return null;
        }

        Map<Integer, List<StaffEventGradeDto>> status2Grade = staffEventGrades
                .stream()
                .collect(Collectors.groupingBy(StaffEventGradeDto::getLogStatus));

        EventGradeDto dto = new EventGradeDto();
        dto.eventId = staffEventGrades.get(0).getEventId();

        List<StaffEventGradeDto> eventGradeDtos = status2Grade.get(EventLogStatusEnum.JOIN.getCode());
        dto.joinPeopleNumCount = eventGradeDtos != null ? eventGradeDtos.size() : 0;
        dto.joinNumCount = eventGradeDtos != null ? eventGradeDtos.stream().mapToInt(StaffEventGradeDto::getCount).sum() : 0;

        eventGradeDtos = status2Grade.get(EventLogStatusEnum.FINISH.getCode());
        dto.finishJoinPeopleNumCount = eventGradeDtos != null ? eventGradeDtos.size() : 0;
        dto.finishJoinNumCount = eventGradeDtos != null ? eventGradeDtos.stream().mapToInt(StaffEventGradeDto::getCount).sum() : 0;

        dto.statisticalCount = Optional.ofNullable(eventId2StatisticalCount.get(dto.eventId)).orElse(0);

        dto.setGradeExplain(eventId2Dto.get(dto.eventId).getGradeExplain());

        return dto;
    }


    public void mergeEventGrade(EventGradeDto staffEventGradeDto) {
        if (staffEventGradeDto != null) {
            eventGrade = MathUtil.add(eventGrade, staffEventGradeDto.getEventGrade());
            joinPeopleNumCount = MathUtil.add(joinPeopleNumCount, staffEventGradeDto.getJoinPeopleNumCount());
            joinNumCount = MathUtil.add(joinNumCount, staffEventGradeDto.getJoinNumCount());
            finishJoinPeopleNumCount = MathUtil.add(finishJoinPeopleNumCount, staffEventGradeDto.getFinishJoinPeopleNumCount());
            finishJoinNumCount = MathUtil.add(finishJoinNumCount, staffEventGradeDto.getFinishJoinNumCount());
            statisticalCount = staffEventGradeDto.getStatisticalCount();
            gradeExplain = staffEventGradeDto.getGradeExplain();
        }

    }

    public EventGradeDto copy() {
        return BeanUtils.copy(this, EventGradeDto.class);
    }
}
