package cn.com.duiba.duiba.qutui.center.api.dto.task;

import cn.com.duiba.duiba.qutui.center.api.dto.staff.StaffDto;
import cn.com.duiba.duiba.qutui.center.api.enums.StaffIdentityEnum;
import cn.com.duiba.duiba.qutui.center.api.util.MathUtil;
import lombok.Data;

import java.io.Serializable;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName SetupGradeDto.java
 * @Description TODO
 * @createTime 2021年03月23日 11:43:00
 */
@Data
public class SetupStaffIdentityGradeDetailDto implements Serializable {


    /**
     * 员工类型
     */
    private Integer staffIdentity;

    /**
     * 员工类型中文
     */
    private String staffIdentityTxt;
    /**
     * 业绩总分
     */
    private Double grade;

    public void mergeGrade(SetupStaffIdentityGradeDetailDto staffGrade) {
        grade = MathUtil.add(grade, staffGrade.getGrade());
    }

    public SetupStaffIdentityGradeDetailDto() {
    }

    public SetupStaffIdentityGradeDetailDto(StaffDto staffDto, Double grade) {
        this.staffIdentity = staffDto.getStaffIdent();
        StaffIdentityEnum identityEnum = StaffIdentityEnum.getEnum(staffDto.getStaffIdent());
        if (identityEnum != null) {
            this.staffIdentityTxt = identityEnum.getDesc();
        }
        this.grade = grade;
    }

    public SetupStaffIdentityGradeDetailDto copy() {
        SetupStaffIdentityGradeDetailDto detailDto = new SetupStaffIdentityGradeDetailDto();
        detailDto.setStaffIdentity(this.staffIdentity);
        detailDto.setStaffIdentityTxt(this.staffIdentityTxt);
        detailDto.setGrade(this.getGrade());
        return detailDto;
    }
}
