package cn.com.duiba.duiba.qutui.center.api.remoteservice.staff;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.staff.StaffCustomerDto;
import cn.com.duiba.duiba.qutui.center.api.param.staffcustomer.CustomerListParam;

import java.util.List;

/**
* 员工的客户表 RemoteService
* @author xiaotian
* 2021-3-17 15:32:12
*/
@AdvancedFeignClient
public interface RemoteStaffCustomerService {
    /**
    * 新增记录
    */
	Boolean save(StaffCustomerDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(StaffCustomerDto dto);
    /**
    * 根据id获取
    */
    StaffCustomerDto getById(Long id);


    /**
     * 通过staffId和userId列表，获取客户信息获取员工信息
     * @param staffId
     * @param userIds
     * @return
     */
    List<StaffCustomerDto> getByStaffIdAndUserIds(Long staffId, List<Long> userIds);


    /**
     * 筛选员工列表
     *
     * @return
     */
    List<StaffCustomerDto> queryList(CustomerListParam customerListParam);


    /**
     * 统计数量
     *
     * @return
     */
    Integer queryListCount(CustomerListParam customerListParam);


}
