/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.duiba.qutui.center.api.dto.wxmessage.wrapper;

import cn.com.duiba.duiba.qutui.center.api.dto.wxmessage.BaseMessageDto;
import cn.com.duiba.duiba.qutui.center.api.dto.wxmessage.MessageUserDto;
import cn.com.duiba.duiba.qutui.center.api.dto.wxmessage.innerlog.WxSendEmbedDto;
import cn.com.duiba.duiba.qutui.center.api.dto.wxmessage.pushtask.PushTaskDto;
import cn.com.duiba.duiba.qutui.center.api.dto.wxmessage.template.TemplateMessageDto;
import cn.com.duiba.duiba.qutui.center.api.dto.wxmessage.wrapper.BatchWxMessageWrapperDto;
import cn.com.duiba.duiba.qutui.center.api.dto.wxmessage.wrapper.SingleWxMessageWrapperDto;
import cn.com.duiba.duiba.qutui.center.api.dto.wxmessage.wrapper.WxMessageWrapperDto;
import cn.com.duiba.duiba.qutui.center.api.enums.DegradedTypeEnum;
import cn.com.duiba.duiba.qutui.center.api.enums.MessageTypeEnum;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMessageWrapperBuilder {
    private static final Logger log = LoggerFactory.getLogger(WxMessageWrapperBuilder.class);
    private Integer messageType;
    @NotNull(message="\u6d88\u606f\u4f53\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u6d88\u606f\u4f53\u4e0d\u80fd\u4e3a\u7a7a") BaseMessageDto messageDto;
    @NotNull(message="\u63a5\u53d7\u6d88\u606f\u7684\u516c\u4f17\u53f7\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u63a5\u53d7\u6d88\u606f\u7684\u516c\u4f17\u53f7\u4e0d\u80fd\u4e3a\u7a7a") Long oaId;
    private WxSendEmbedDto wxSendEmbedBean;
    @NotNull(message="\u964d\u7ea7\u7b56\u7565\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u964d\u7ea7\u7b56\u7565\u4e0d\u80fd\u4e3a\u7a7a") Integer degradedType = DegradedTypeEnum.DISCARD.getCode();
    private Boolean needPushResult;
    private PushTaskDto pushTaskDto;
    private WxMessageWrapperDto degradedMessageWrapperDto;

    public WxMessageWrapperBuilder setOaId(Long oaId) {
        if (Objects.isNull(oaId) || oaId < 1L) {
            throw new RuntimeException("oaId \u975e\u6cd5");
        }
        this.oaId = oaId;
        return this;
    }

    public WxMessageWrapperBuilder setNeedPushResult(Boolean needPushResult) {
        this.needPushResult = needPushResult;
        return this;
    }

    public WxMessageWrapperBuilder setPushTaskDto(PushTaskDto pushTaskDto) {
        if (Objects.isNull(pushTaskDto) || Objects.isNull(pushTaskDto.getTaskId()) || Objects.isNull(pushTaskDto.getPushTaskType())) {
            throw new RuntimeException("\u63a8\u9001\u4efb\u52a1\u5bf9\u8c61\u9519\u8bef");
        }
        this.pushTaskDto = pushTaskDto;
        return this;
    }

    public WxMessageWrapperBuilder setMessageDto(Integer messageType, BaseMessageDto messageDto) {
        MessageTypeEnum.getByCode(messageType);
        this.messageType = messageType;
        this.messageDto = messageDto;
        return this;
    }

    public WxMessageWrapperBuilder setEmbedParam(String pushEventType, Map<String, Object> customMap) {
        WxSendEmbedDto wxSendEmbedDto;
        this.wxSendEmbedBean = wxSendEmbedDto = new WxSendEmbedDto(pushEventType, customMap);
        return this;
    }

    public WxMessageWrapperBuilder setDegradedMessage(WxMessageWrapperDto degradedMessageWrapperDto) {
        degradedMessageWrapperDto.setDegradedType(DegradedTypeEnum.DISCARD.getCode());
        degradedMessageWrapperDto.setDegradedMessageWrapperDto(null);
        this.degradedType = DegradedTypeEnum.OTHER_MESSAGE.getCode();
        this.degradedMessageWrapperDto = degradedMessageWrapperDto;
        return this;
    }

    public WxMessageWrapperBuilder setDegradedTemplateMessage(TemplateMessageDto templateMessageDto, MessageUserDto messageUserDto) {
        SingleWxMessageWrapperDto degradedMessageWrapperDto = new SingleWxMessageWrapperDto();
        degradedMessageWrapperDto.setMessageType(MessageTypeEnum.TEMPLATE.getCode());
        degradedMessageWrapperDto.setMessageDto(templateMessageDto);
        degradedMessageWrapperDto.setDegradedType(DegradedTypeEnum.DISCARD.getCode());
        degradedMessageWrapperDto.setDegradedMessageWrapperDto(null);
        degradedMessageWrapperDto.setUser(messageUserDto);
        this.degradedType = DegradedTypeEnum.OTHER_MESSAGE.getCode();
        this.degradedMessageWrapperDto = degradedMessageWrapperDto;
        return this;
    }

    public BatchWxMessageWrapperDto createBatchMessage(List<MessageUserDto> userList) {
        BatchWxMessageWrapperDto batchWxMessageWrapperDto = new BatchWxMessageWrapperDto();
        batchWxMessageWrapperDto.setWxSendEmbedBean(this.wxSendEmbedBean);
        batchWxMessageWrapperDto.setMessageDto(this.messageDto);
        batchWxMessageWrapperDto.setOaId(this.oaId);
        batchWxMessageWrapperDto.setMessageType(this.messageType);
        batchWxMessageWrapperDto.setDegradedType(this.degradedType);
        batchWxMessageWrapperDto.setDegradedMessageWrapperDto(this.degradedMessageWrapperDto);
        batchWxMessageWrapperDto.setNeedPushResult(this.needPushResult);
        batchWxMessageWrapperDto.setPushTaskDto(this.pushTaskDto);
        batchWxMessageWrapperDto.setUserList(userList);
        return batchWxMessageWrapperDto;
    }

    public SingleWxMessageWrapperDto createSingleMessage(MessageUserDto user) {
        SingleWxMessageWrapperDto singleWxMessageWrapperDto = new SingleWxMessageWrapperDto();
        singleWxMessageWrapperDto.setWxSendEmbedBean(this.wxSendEmbedBean);
        singleWxMessageWrapperDto.setMessageDto(this.messageDto);
        singleWxMessageWrapperDto.setOaId(this.oaId);
        singleWxMessageWrapperDto.setMessageType(this.messageType);
        singleWxMessageWrapperDto.setDegradedType(this.degradedType);
        singleWxMessageWrapperDto.setDegradedMessageWrapperDto(this.degradedMessageWrapperDto);
        singleWxMessageWrapperDto.setNeedPushResult(this.needPushResult);
        singleWxMessageWrapperDto.setPushTaskDto(this.pushTaskDto);
        singleWxMessageWrapperDto.setUser(user);
        return singleWxMessageWrapperDto;
    }
}

