package cn.com.duiba.duiba.qutui.center.api.enums;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName GradeSetupTypeEnum.java
 * @Description 业绩排行榜机构范围
 * @createTime 2021年04月19日 10:33:00
 */
public enum GradeSetupRangeEnum {
    ALL_SETUP(0, "所有机构"),
    ONE_SETUP(1, "一级机构"),
    TWO_SETUP(2, "二级机构"),
    THREE_SETUP(3, "三级机构"),
    FOUR_SETUP(4, "四级机构"),
    FIVE_SETUP(5, "五级机构"),
    FATHER_SETUP(6, "所属机构"),
    ;
    private int code;
    private String desc;

    GradeSetupRangeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static GradeSetupRangeEnum getEnum(int code){
        for (GradeSetupRangeEnum value : GradeSetupRangeEnum.values()) {
            if (code == value.getCode()){
                return value;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
