package cn.com.duiba.duiba.qutui.center.api.remoteservice.task;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.task.EventLogDto;
/**
* 参与记录 RemoteService
* @author xiaotian
* 2021-3-16 15:37:15
*/
@AdvancedFeignClient
public interface RemoteEventLogService {
    /**
    * 新增记录
    */
	Boolean save(EventLogDto dto);
    /**
    * 根据id更新
    */
    Boolean updateById(EventLogDto dto);

    String joinEventLog(String openId, String staffId, String projectId) throws BizException;

    Boolean finishEventLog(String openId, String statisticsNum) throws BizException;

    /**
     * 根据logId获取详情
     * @param logId
     * @return
     */
    EventLogDto getByLogId(Long logId);


}
