package cn.com.duiba.duiba.qutui.center.api.remoteservice.message;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.wxmessage.wrapper.SingleWxMessageWrapperDto;

/**
 * Created by xiaotian on 2020-02-11.
 * 小程序异步发送消息
 */
@AdvancedFeignClient
public interface RemoteAsyncMpMessageSenderService {

    /**
     * 发送客服消息
     * 不入mq队列 优先发送
     * @param singleWxMessageWrapperDto 客服消息包装体
     */
    void sendCustomerMessage(SingleWxMessageWrapperDto singleWxMessageWrapperDto);

    /**
     * 发送模版消息
     * 不入mq队列 优先发送
     * @param singleWxMessageWrapperDto 模版消息包装体
     */
    void sendTemplateMessage(SingleWxMessageWrapperDto singleWxMessageWrapperDto);

    /**
     * 发送订阅消息
     * 不入mq队列 优先发送
     * @param singleWxMessageWrapperDto 订阅消息体
     */
    void sendSubscribeMessage(SingleWxMessageWrapperDto singleWxMessageWrapperDto);
}
