package cn.com.duiba.duiba.qutui.center.api.enums;

import java.util.Objects;

/**
 * 微信各种账号的业务类型。
 * 如需请求带有access_token 参数的接口，请在{@link  RequestTokenHandle}实现中做相对应的处理
 * Created by xiaotian on 2019-06-01.
 */
public enum OATypeEnum {
    OPEN_PL(1,null,"第三方服务平台"),

    OPEN_MP(2,OaTargetEnum.MP.getCode(),"第三方服务平台服务的小程序"),

    OA(3,OaTargetEnum.OA.getCode(),"自有公众号"),

    OPEN_OA(4,OaTargetEnum.OA.getCode(),"第三方服务平台服务的公众号"),

    OPEN_SUITE(5,OaTargetEnum.SUITE.getCode(), "三方套件应用"),

    ;
    private final Integer type;
    //1:公众号 2：小程序 3:web应用
    private final Integer target;
    private final  String desc;

    OATypeEnum(Integer type, Integer target, String desc) {
        this.type = type;
        this.target = target;
        this.desc = desc;
    }

    public Integer getTarget() {
        return target;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static OATypeEnum typeOf(Integer type) {
        for (OATypeEnum e :values())
            if (Objects.equals(type, e.getType())) {
                return e;
            }
        throw new UnsupportedOperationException("不支持的oa类型");
    }

    /**
     * 判断是否为公众号
     * @param type
     * @return
     */
    public static boolean isOa(Integer type){
        if(OA.getType().equals(type) || OPEN_OA.getType().equals(type)){
            return true;
        }
        return false;
    }

    /**
     * 判断是否为小程序
     * @param type
     * @return
     */
    public static boolean isMp(Integer type){
        if(OPEN_MP.getType().equals(type)){
            return true;
        }
        return false;
    }
}
