package cn.com.duiba.duiba.qutui.center.api.param.common;

import lombok.Getter;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName PageNewQuery.java
 * @Description TODO
 * @createTime 2021年04月29日 17:51:00
 */
@Getter
public class PageNewQuery implements Serializable {

    protected Integer current;
    protected Integer pageSize;
    private Integer offset;

    public <T extends PageNewQuery> T setCurrent(Integer current) {
        this.current = current;
        return (T) this;
    }

    public <T extends PageNewQuery> T setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return (T) this;
    }

    public Integer getOffset() {
        return getOffset(null);
    }

    /**
     * 默认值
     *
     * @param df
     * @return
     */
    public Integer getOffset(Integer df) {
        if (Objects.nonNull(offset)) {
            return offset;
        }
        if (Objects.nonNull(current) && Objects.nonNull(pageSize)) {
            return (current - 1) * pageSize;
        }
        return df;
    }
}
