package cn.com.duiba.duiba.qutui.center.api.param.mpAccount.audit;

import lombok.Data;

import java.io.Serializable;

/**
 * @author wangxukai
 * @description 审核代码参数
 * @date ：Created in 2021/3/24
 */
@Data
public class ComponentAuditItemParam implements Serializable {

    /**
     * 小程序的页面，可通过获取小程序的页面列表接口获得
     */
    private String address;
    /**
     * 小程序的标签，用空格分隔，标签至多 10 个，标签长度至多 20
     */
    private String tag;
    /**
     * 一级类目名称
     */
    private String firstClass;

    /**
     * 二级类目名称
     */
    private String secondClass;
    /**
     * 三级类目名称
     */
    private String thirdClass;
    /**
     * 一级类目的 ID
     */
    private Long firstId;
    /**
     * 二级类目的 ID
     */
    private Long secondId;
    /**
     * 三级类目的 ID
     */
    private Long thirdId;
    /**
     * 小程序页面的标题,标题长度至多 32
     */
    private String title;
}
