package cn.com.duiba.duiba.qutui.center.api.remoteservice.task;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.staff.StaffDto;
import cn.com.duiba.duiba.qutui.center.api.dto.task.ProjectPushTestStaffDto;

import java.util.List;

/**
* 项目推广人员测试表 RemoteService
* @author xiaotian
* 2021-4-9 11:02:42
*/
@AdvancedFeignClient
public interface RemoteProjectPushTestStaffService {
    /**
    * 新增记录
    */
	Boolean save(ProjectPushTestStaffDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(ProjectPushTestStaffDto dto);
    /**
    * 根据id获取
    */
    ProjectPushTestStaffDto getById(Long id);

    /**
     * 修改项目推广测试人
     * @param projectId 项目id
     * @param createId 创建人账号
     * @param addStaffIds 要添加的测试人员
     * @return
     */
    Boolean updatePushTestStaffs(Long projectId,Long createId, List<Long> addStaffIds) throws BizException;


    List<StaffDto> getPushTestStaffs(Long projectId);


}
