package cn.com.duiba.duiba.qutui.center.api.remoteservice.task;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.qutui.center.api.dto.task.ProjectDto;
import cn.com.duiba.duiba.qutui.center.api.dto.task.ProjectEventDto;
import cn.com.duiba.duiba.qutui.center.api.dto.task.ProjectPushLevelDto;
import cn.com.duiba.duiba.qutui.center.api.dto.task.ProjectPushStaffDto;
import cn.com.duiba.duiba.qutui.center.api.dto.task.TaskProjectDto;
import cn.com.duiba.duiba.qutui.center.api.param.common.PageNewQuery;
import cn.com.duiba.duiba.qutui.center.api.result.PageResult;
import cn.com.duiba.duiba.qutui.center.api.result.task.ProjectResult;

import java.util.List;

/**
 * 项目表 RemoteService
 *
 * @author xiaotian
 * 2021-3-19 15:09:43
 */
@AdvancedFeignClient
public interface RemoteProjectService {
    /**
     * 新增记录
     */
    Boolean save(ProjectDto dto);

    /**
     * 根据id删除
     */
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    Boolean updateById(ProjectDto dto);

    /**
     * 根据id获取
     */
    ProjectDto getById(Long id);

    /**
     * 通过id列表片获取
     *
     * @return
     */
    List<ProjectDto> listByIds(List<Long> ids);

    /**
     * 添加项目
     *
     * @param createId
     * @param project
     * @param projectEvents
     * @param pushLevelDtoList
     * @param pushStaffDtoList
     * @return
     * @throws BizException
     */
    ProjectResult addProject(Long createId, ProjectDto project,
                             List<ProjectEventDto> projectEvents,
                             List<ProjectPushLevelDto> pushLevelDtoList,
                             List<ProjectPushStaffDto> pushStaffDtoList) throws BizException;

    /**
     * 批量上下架
     *
     * @param projectIds
     * @param staffId
     * @param status
     * @return
     * @throws BizException
     */
    boolean updateProjectStatus(List<Long> projectIds, Long staffId, Integer status) throws BizException;

    /**
     * 项目修改编辑
     *
     * @param createId
     * @param project
     * @param projectEvents
     * @return
     * @throws BizException
     */
    ProjectResult updateProject(Long createId,
                                ProjectDto project,
                                List<ProjectEventDto> projectEvents,
                                List<ProjectPushLevelDto> pushLevelDtoLis) throws BizException;


    /**
     * 带分页的查找项目
     *
     * @param setupId
     * @param status
     * @param projectName
     * @param projectId
     * @param pageNum
     * @param pageSize
     * @return
     */
    PageResult<ProjectDto> getProjectList(Long setupId, Long status, String projectName, Long projectId,
                                          Integer pageNum, Integer pageSize) throws BizException;

    ProjectResult getProjectInfo(Long projectId) throws BizException;


    PageResult<TaskProjectDto> getTaskProjectList(Long setupId, PageNewQuery pageNewQuery) throws BizException;

}
