package cn.com.duiba.duiba.qutui.center.api.result.task;

import cn.com.duiba.duiba.qutui.center.api.dto.content.StaffContentDto;
import cn.com.duiba.duiba.qutui.center.api.dto.setup.SetupDto;
import cn.com.duiba.duiba.qutui.center.api.dto.task.ProjectDto;
import cn.com.duiba.duiba.qutui.center.api.dto.task.SetupGradeDto;
import cn.com.duiba.wolf.utils.BeanUtils;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName StaffProjectResult.java
 * @Description TODO
 * @createTime 2021年03月22日 13:49:00
 */
@Data
public class StaffProjectResult implements Serializable {
    /**
     * 项目id
     */
    private Long id;
    /**
     * 机构id
     */
    private Long setupId;
    /**
     * 项目展示名称
     */
    private String projectTxt;
    /**
     * 项目简介
     */
    private String projectContext;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 项目有效期开始时间
     */
    private Date startTime;

    /**
     * 项目有效期结束时间
     */
    private Date endTime;
    /**
     * 正在推广的职工头像
     */
    private String pushingStaffAvatars;

    /**
     * 机构名称
     */
    private String setupName;

    private Integer pushType;

    private Long scId;

    /**
     * 机构排名
     */
    private Integer setupGradeRank;

    private Integer staffGradeRank;

    public static StaffProjectResult buildStaffProjectResult(ProjectDto projectDto, String pushingStaffAvatars,
                                                             SetupDto setup, SetupGradeDto setupGrade,
                                                             Integer staffGrade,
                                                             StaffContentDto scid) {
        StaffProjectResult staffProjectResult = BeanUtils.copy(projectDto, StaffProjectResult.class);
        staffProjectResult.setPushingStaffAvatars(pushingStaffAvatars);
        if (setupGrade != null) {
            staffProjectResult.setSetupGradeRank(setupGrade.getGradeRank());
        }
        staffProjectResult.setStaffGradeRank(staffGrade);
        staffProjectResult.setSetupName(setup.getSetupName());
        staffProjectResult.setSetupId(setup.getId());
        staffProjectResult.setPushType(projectDto.getPushType());
        if (scid != null) {
            staffProjectResult.setScId(scid.getId());
        }
        return staffProjectResult;
    }

}
