package cn.com.duiba.duiba.qutui.center.api.dto.task;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * 事件表
 * 2021-3-16 15:35:49
 */
@Data
public class EventDto implements Serializable {

    /**
     * 创建者id
     */
    private Long createId;

    /**
     * 事件数据，json格式
     */
    private String eventData;

    /**
     * 事件名称
     */
    private String eventName;

    /**
     * 业绩计算，json格式
     */
    private String eventResult;

    /**
     * 事件状态，0：未上架 1：已经上架
     */
    private Integer eventStatus;

    /**
     * 事件显示名称
     */
    private String eventTxt;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 事件id,主键，自增
     */
    private Long id;

    /**
     * 修改者id
     */
    private Long modifiedId;

    /**
     * 机构id
     */
    private Long setupId;

    /**
     * 统计编码
     */
    private String statisticsNum;

    /**
     * 客户数据，json格式
     */
    private String userData;

    public EventGradeDto getEventGradeDto() {
        EventGradeDto copy = BeanUtils.copy(getEventDataDto(), EventGradeDto.class);
        copy.setEventId(id);
        copy.setEventTxt(eventTxt);
        if (StringUtils.isBlank(copy.getJoinPeopleNumText())) {
            copy.setJoinPeopleNumText("参与人数");
        }
        if (StringUtils.isBlank(copy.getJoinNumText())) {
            copy.setJoinNumText("参与次数");

        }
        if (StringUtils.isBlank(copy.getFinishJoinPeopleNumText())) {
            copy.setFinishJoinPeopleNumText("完成人数");

        }
        if (StringUtils.isBlank(copy.getFinishJoinNumText())) {
            copy.setFinishJoinNumText("完成次数");

        }
        EventResultDto eventResultDto = getEventResultDto();
        if (EventResultDto.STATISTICAL_RULE_COUNT.equals(eventResultDto.getStatisticalRule())) {
            copy.setStatisticalText("完成次数(自然流量)");
        } else {
            copy.setStatisticalText("完成人数(自然流量)");
        }

        return copy;
    }

    public EventDataDto getEventDataDto() {
        try {
            return JSON.parseObject(eventData, EventDataDto.class);
        } catch (Exception e) {
            return null;
        }
    }


    public EventResultDto getEventResultDto() {
        try {
            return JSON.parseObject(eventResult, EventResultDto.class);
        } catch (Exception e) {
            return null;
        }
    }


    public EventUserDataDto getEventUserDataDto() {
        try {
            return JSON.parseObject(userData, EventUserDataDto.class);
        } catch (Exception e) {
            return null;
        }
    }


}

