package cn.com.duiba.duiba.qutui.center.api.util;

import cn.com.duiba.wolf.utils.DateUtils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2021/3/17 22:15
 * @Description:
 */
public class DateUtil {

    private final static SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy-MM-dd");


    /**
     * 获得今年的开始时间
     *
     * @return
     */
    public static Date getCurrentYearStartTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(Calendar.MONTH, 0);
        todayStart.set(Calendar.DATE, 1);
        todayStart.set(Calendar.HOUR_OF_DAY, 0);
        todayStart.set(Calendar.MINUTE, 0);
        todayStart.set(Calendar.SECOND, 0);
        todayStart.set(Calendar.MILLISECOND, 0);
        return todayStart.getTime();
    }

    /**
     * 获取前/后半年的开始时间
     *
     * @return
     */
    public static Date getHalfYearStartTime() {
        Calendar c = Calendar.getInstance();
        int currentMonth = c.get(Calendar.MONTH) + 1;
        if (currentMonth >= 1 && currentMonth <= 6) {
            c.set(Calendar.MONTH, 0);
        } else if (currentMonth >= 7 && currentMonth <= 12) {
            c.set(Calendar.MONTH, 6);
        }
        c.set(Calendar.DATE, 1);
        c.set(Calendar.HOUR_OF_DAY, 0);
        c.set(Calendar.MINUTE, 0);
        c.set(Calendar.SECOND, 0);
        c.set(Calendar.MILLISECOND, 0);
        return c.getTime();

    }

    /**
     * 当前季度的开始时间
     *
     * @return
     */
    public static Date getCurrentQuarterStartTime() {
        Calendar c = Calendar.getInstance();
        int currentMonth = c.get(Calendar.MONTH) + 1;
        if (currentMonth >= 1 && currentMonth <= 3) {
            c.set(Calendar.MONTH, 0);
        } else if (currentMonth >= 4 && currentMonth <= 6) {
            c.set(Calendar.MONTH, 3);
        } else if (currentMonth >= 7 && currentMonth <= 9) {
            c.set(Calendar.MONTH, 4);
        } else if (currentMonth >= 10 && currentMonth <= 12) {
            c.set(Calendar.MONTH, 9);
        }
        c.set(Calendar.DATE, 1);

        c.set(Calendar.HOUR_OF_DAY, 0);
        c.set(Calendar.MINUTE, 0);
        c.set(Calendar.SECOND, 0);
        c.set(Calendar.MILLISECOND, 0);

        return c.getTime();
    }

    /**
     * 获得本月的开始时间
     *
     * @return
     */
    public static Date getCurrentMonthStartTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(Calendar.DATE, 1);
        todayStart.set(Calendar.HOUR_OF_DAY, 0);
        todayStart.set(Calendar.MINUTE, 0);
        todayStart.set(Calendar.SECOND, 0);
        todayStart.set(Calendar.MILLISECOND, 0);
        return todayStart.getTime();
    }


    /**
     * 获取本周第一天
     *
     * @return
     */
    public static Date getWeekStart() {
        Date today = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(today);
        int weekday = c.get(Calendar.DAY_OF_WEEK);
        if (weekday == 1) {
            return DateUtils.getDayStartTime(DateUtils.daysAddOrSub(today, -6));
        } else {
            return DateUtils.getDayStartTime(DateUtils.daysAddOrSub(today, 2 - weekday));
        }
    }

    /**
     * 获取整点时间
     */
    public static Date getHourTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(Calendar.MINUTE, 0);
        todayStart.set(Calendar.SECOND, 0);
        todayStart.set(Calendar.MILLISECOND, 0);
        return todayStart.getTime();
    }

    /**
     * 获取每天开始时间
     */
    public static Date getDayTime(int offSetDay) {
        Calendar todayStart = Calendar.getInstance();
        todayStart.add(Calendar.DATE, offSetDay);
        todayStart.set(Calendar.HOUR_OF_DAY, 0);
        todayStart.set(Calendar.MINUTE, 0);
        todayStart.set(Calendar.SECOND, 0);
        todayStart.set(Calendar.MILLISECOND, 0);
        return todayStart.getTime();
    }

    /**
     * 获取每天结束时间
     */
    public static Date getEndTime(int offSetDay) {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.add(Calendar.DATE, offSetDay);
        todayEnd.set(Calendar.HOUR_OF_DAY, 23);
        todayEnd.set(Calendar.MINUTE, 59);
        todayEnd.set(Calendar.SECOND, 59);
        todayEnd.set(Calendar.MILLISECOND, 999);
        return todayEnd.getTime();
    }


    public static void main(String[] args) {
        System.out.println(DateUtils.getSecondStr(getHourTime()));
        System.out.println(DateUtils.getSecondStr(getDayTime(0)));
        System.out.println(DateUtils.getSecondStr(getDayTime(-1)));
        System.out.println(DateUtils.getSecondStr(getCurrentMonthStartTime()));
        System.out.println(DateUtils.getSecondStr(getCurrentQuarterStartTime()));
        System.out.println(DateUtils.getSecondStr(getHalfYearStartTime()));
        System.out.println(DateUtils.getSecondStr(getCurrentYearStartTime()));
    }
}
