package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.DuibaGuessDO;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.domain.vo.AddActivityVO;

import java.util.Date;
import java.util.List;

public interface RemoteDuibaGuessService {

	public DuibaGuessDO find(Long id);
	
	public List<DuibaGuessDO> findByPage(Integer offset, Integer max, String title, Integer id);
	
	public Long findPageCount(String title, Integer id);
	public int updateStatus(Long id, int status);
	
	public int delete(Long id);
	public DuibaGuessDO insert(DuibaGuessDO duibaGuessDO);
	public int updateInfoForm(DuibaGuessDO duibaGuessDO);
	public int updateAutoOffDateNull(Date autoOffDate, Long id);
	
	public void updateSwitches(Long id, Integer switches);
	/**
	 * 修改开奖后的主表信息
	 * updateOpenWinning:(这里用一句话描述这个方法的作用). <br/>
	 *
	 * @author liyang
	 * @param id
	 * @since JDK 1.6
	 */
	public void updateOpenWinning(Long id, String luckNum, Long rightSelectionId, Integer isAccurate);

	public List<DuibaGuessDO> findAllByIds(List<Long> ids);

	public List<AddActivityVO> findAllGuess(Long appId);

	public Long addDuibaGuessToDeveloper(Long appId, Long duibaGuessId) throws BusinessException;


	public List<DuibaGuessDO> findAutoOff();

	public int updateOpenPrize(Long id);
}
