package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.DuibaNgameDO;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.domain.vo.ActivityExtraInfoVO;
import cn.com.duiba.service.item.domain.vo.AddActivityVO;

import java.util.List;

public interface RemoteDuibaNgameService {

	List<DuibaNgameDO> findByPage(Integer offset, Integer max, String title, Integer id);
	
	Long findByPageCount(String title, Integer id);
	
	DuibaNgameDO findOpenPrizeForUpdate(Long id);
	
	int count();
	
	DuibaNgameDO find(Long id);
	
	String findTagById(Long id);

	DuibaNgameDO add(DuibaNgameDO duibaNgameDO);
	
	void delete(Long id);
	
	int updateTagById(Long id, String tag);
	
	void update(DuibaNgameDO duibaNgameDO);
	
	void updateSwitch(DuibaNgameDO duibaNgameDO);

	List<DuibaNgameDO> findAllByIds(List<Long> ids);
	public List<AddActivityVO> findAllNgame(Long appId);
	public Long addDuibaNgameToDeveloper(Long appId, Long duibaNgameId) throws BusinessException;

	public List<DuibaNgameDO> findListByIds(List<Long> ids);
	public int updateOpenPrize(Long id);
	public List<DuibaNgameDO> findAutoOff();
	public int updateStatus(Long id, Integer status);
	public ActivityExtraInfoVO findExtraInfoById(Long id);
	public int updateActivityCategoryId(long id,Long activityCategoryId);
}
