package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.DuibaQuestionRecordDO;
import cn.com.duiba.service.domain.vo.PaginationVO;
import cn.com.duiba.service.exception.BusinessException;

import java.util.List;

/**
 * Created by wenqi.huang on 16/6/3.
 */
public interface RemoteDuibaQuestionRecordService {

    List<DuibaQuestionRecordDO> findByBankIdAndLimit(Long qBankId, Integer limit);

    /**
     * 根据题库id的字符串查询出总数
     * @return
     */
    public Long findCountByBankIdsStr(List<String> bankIds);
    public DuibaQuestionRecordDO findById(Long id);
    public Long findTotalCount(Long questionBankId);

    //from DuibaQuestionRecordServiceImpl in manager,以下这些方法因为名字冲突,所以加上了_manager后缀

    public DuibaQuestionRecordDO insert_manager(DuibaQuestionRecordDO questionRecordDO) throws BusinessException;
    public PaginationVO<DuibaQuestionRecordDO> findByPage_manager(Long questionBankId, Integer offset, Integer max);
    /**
     * 删除题库的一个题目
     * @param id
     * @return
     * @throws Exception
     */
    public void delete_manager(Long id) throws BusinessException;
}
