/**
 * credits MoneyUtil.java
 * 
 * File Created at 2016年1月10日 上午11:06:31
 * $Id$
 *
 * Copyright 2015 duiba.com Croporation Limited.
 * All rights reserved.
 */
package cn.com.duiba.service.tools;

import java.math.BigDecimal;
import java.text.DecimalFormat;

/**
 *金额相关工具类
 * @create 2016年1月10日 上午11:06:31
 * @author Hermit
 * @version
 */
public class MoneyUtil {
    
    public static final String Hundreds = "100";

    /**
     * 把元单位的金额转化成分制
     * @param money
     * @return
     */
    public static Long convertToCent (String money) {
        return new BigDecimal(Hundreds).multiply(new BigDecimal(money)).longValue();
    }
    
    /**
     * 将分制的金额格式式化为保留2位小数的元制
     * @param money
     * @return
     */
    public static String FormaterMoneyToKeep2Point (Long money) {
        return new DecimalFormat("0.00").format(new BigDecimal(money).divide(new BigDecimal(Hundreds)).doubleValue());
    }
    
}
