package cn.com.duiba.service.item.remoteservice;

import cn.com.duiba.service.domain.dataobject.PermissionDO;

public interface RemotePermissionService {

	public PermissionDO findBySource(Long sourceId, Integer sourceType);
	
	public PermissionDO insert(PermissionDO permissionDO);
	
	public void update(PermissionDO permissionDO);
	
	/**
	 * 查询兑吧活动专用的兑换项是否具有权限
	 */
	public PermissionDO find4DuibaShowcase(String itemId);

	/**
	 * 启用一个权限
	 */
	public int enablePerById(Long id);

	public Long deletePermissionByDuibaSecondsKillActivity(Long duibaSecondsKillActivityId);

	/**
	 * 给活动授权
	 *
	 * @param operatingActivityId
	 */
	public Boolean grantPermissionToOperatingActivity(Long operatingActivityId);

	public Boolean grantPermissionToOperatingActivity(Long operatingActivityId, int sourceType);

	public Long createPermissionByDuibaSecondKill(Long duibaSecondsKillId, String itemIds);

	/**
	 * 更新兑吧活动权限模板
	 *
	 * @param duibaSecondsKillId
	 * @param itemIds
	 * @return
	 */
	public Long updatePermissionByDuibaSecondKill(Long duibaSecondsKillId, String itemIds);

	//from ActivityPermissionService
	/**
	 * 创建兑吧活动权限模板
	 *
	 * @param duibaActivityId
	 */
	public Long createPermissionByDuibaActivity(Long duibaActivityId, String itemIds);

	//from ActivityPermissionService
	/**
	 * 更新兑吧活动权限模板
	 *
	 * @param duibaActivityId
	 * @param itemIds
	 * @return
	 */
	public Long updatePermissionByDuibaActivity(Long duibaActivityId, String itemIds);

	//from ActivityPermissionService

	/**
	 * 删除兑吧活动权限模板
	 *
	 *
	 * @param duibaActivityId
	 */
	public Long deletePermissionByDuibaActivity(Long duibaActivityId);

	/**
	 * 收回活动授权
	 *
	 * @param operatingActivityId
	 */
	public Boolean revokePermissionToOperatingActivity(Long operatingActivityId);

	public Boolean revokePermissionToOperatingActivity(Long operatingActivityId, int sourceType);
}
