package cn.com.duiba.service.domain.dataobject;

import cn.com.duiba.service.domain.BaseDO;

import java.util.Date;

public class BannerRecordsDO extends BaseDO {
	private static final long serialVersionUID = 3782995392687835404L;
	
	public static final String TypeBanner = "banner";
	public static final String TypeButton = "button";

	private Long id;
	private String name;
	private String url;
	private String image;
	private Boolean enable;
	private String type;
	private Integer duibaType;
	private Integer version;

	private Date gmtCreate;
	private Date gmtModified;

	public BannerRecordsDO(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;
			duibaType = 0;
			enable = false;
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}

	public BannerRecordsDO() {
	}

	public BannerRecordsDO(Long id) {
		this.id = id;
		this.gmtModified = new Date();
		toBeUpdate = true;
	}

	public void beforeUpdate() {
		gmtModified = new Date();
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}

	public Boolean getEnable() {
		return enable;
	}

	public void setEnable(Boolean enable) {
		this.enable = enable;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Integer getDuibaType() {
		return duibaType;
	}

	public void setDuibaType(Integer duibaType) {
		this.duibaType = duibaType;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getVersion() {
		return version;
	}

	public void setVersion(Integer version) {
		this.version = version;
	}
	
}
