package cn.com.duiba.service.domain.dataobject;

import java.util.Date;

import cn.com.duiba.service.domain.BaseDO;

/**
 * 兑吧计划任务
 */
public class DuibaScheduledTasksDO extends BaseDO {
	private static final long serialVersionUID = 1206761085953167803L;

	public static final String TYPE_COUPON = "coupon"; // 优惠券
	public static final String TYPE_OBJECT = "object"; // 实物
	public static final String TYPE_DUIBA_TURNTABLE = "duibaTurntable"; // 兑吧大转盘
	public static final String TYPE_DUIBA_SINGLE_LOTTERY = "duibaSingleLottery"; // 兑吧单品抽奖
	public static final String TYPE_DUIBA_ACTIVITY = "duibaActivity"; // 专题活动
	public static final String TYPE_DUIBA_SHAKE = "duibaShake";	// 摇一摇
	public static final String TYPE_DUIBA_SCRATCH = "duibaScratch";//刮刮乐
	public static final String TYPE_DUIBA_TIGER = "duibaTiger";//老虎机
	public static final String TYPE_DUIBA_FLOP = "duibaFlop";//趣味翻牌
	public static final String TYPE_DUIBA_SMASHG = "duibaSmashg";//砸彩蛋
	//Start chaijiangang,幸运转盘改为活动工具,2016/04/26
	public static final String TYPE_DUIBA_HDTOOL_TURNTABLE = "duibaHdToolTurntable";//活动工具幸运转盘
	//End chaijiangang,幸运转盘改为活动工具,2016/04/26
	public static final String TYPE_GAME_SANTA = "gameSanta";	// 游戏圣诞
	public static final String TYPE_GAME_YEAR_AWARD = "gameYearAward";	// 游戏数年终奖
	public static final String TYPE_GAME_GIRL = "gameGirl";	// 女神游戏
	public static final String TYPE_GAME_JIONG = "gameJiong";	// 人在囧途
	public static final String TYPE_DUIBA_SECONDS_KILL_ACTIVITY = "duibaSecondsKillActivity";	// 秒杀专题
	public static final String TYPE_DUIBA_QUESTION = "duibaQuestion";	// 兑吧答题活动
	public static final String TYPE_DUIBA_SECKILL = "duibaSeckill";	// 兑吧秒杀活动
	public static final String TYPE_DUIBA_QUIZZ = "duibaQuizz";//兑吧测试题活动
	public static final String TYPE_DUIBA_NGAME = "duibaNgame";//新游戏
	public static final String TYPE_DUIBA_GUESS = "duibaGuess";//竞猜
	
	public static final String SOURCE_TYPE_ITEM = "item"; // 来源item
	public static final String SOURCE_TYPE_DUIBA_TURNTABLE = "duibaTurntable"; // 来源duibaTurntable
	public static final String SOURCE_TYPE_DUIBA_SINGLE_LOTTERY = "duibaSingleLottery"; // 来源duibaSingleLottery
	public static final String SOURCE_TYPE_DUIBA_ACTIVITY = "duibaActivity"; // 来源duibaActivity
	public static final String SOURCE_TYPE_DUIBA_HDTOOL = "duibaHdtool";	// 来源duibaHdtool
	public static final String SOURCE_TYPE_GAME_CONFIG_DUIBA = "gameConfigDuiba";	// 来源gameConfigDuiba
	public static final String SOURCE_TYPE_SECONDS_KILL_ACTIVITY = "duibaSecondsKillActivity";	// 秒杀专题
	public static final String SOURCE_TYPE_DUIBA_QUESTION = "duibaQuestion"; // 兑吧答题活动
	public static final String SOURCE_TYPE_DUIBA_SECKILL = "duibaSeckill"; // 兑吧秒杀活动
	public static final String SOURCE_TYPE_DUIBA_QUIZZ = "duibaQuizz";//兑吧测试题活动
	public static final String SOURCE_TYPE_DUIBA_NGAME = "duibaNgame";//新游戏
	public static final String SOURCE_TYPE_DUIBA_GUESS = "duibaGuess";//竞猜
	
	public static final String PLACE_BANNER = "placeBanner"; // banner
	public static final String PLACE_ITEM = "placeItem"; // item
	public static final String PLACE_BANNERANDITEM = "placeBannerAndItem"; // bannerAndItem

	public static final int EXCUTE_STATUS_UNOPEN = 0; // 未开启
	public static final int EXCUTE_STATUS_WAIT_EXCUTE = 1; // 待执行
	public static final int EXCUTE_STATUS_HAVE_EXCUTE = 2; // 已执行
	public static final int EXCUTE_STATUS_CANCEL = 3; // 取消

	private Long id;

	private String title; // 任务名称

	private String type; // 定时内容类型

	private Long sourceId;

	private String sourceType; // 资源类型

	private String appIds;

	private String places; // banner item bannerAndItem 多个,分隔

	private Date excuteTime; // 任务执行时间

	private Integer excuteStatus; // 执行状态

	private Boolean deleted;

	private Date gmtCreate;

	private Date gmtModified;

	public DuibaScheduledTasksDO() {
	}

	public DuibaScheduledTasksDO(Long id) {
		this.id = id;
		this.gmtModified = new Date();
		toBeUpdate = true;
	}

	public DuibaScheduledTasksDO(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;
			deleted = false;
			gmtCreate = new Date();
			gmtModified = gmtCreate;
		}
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Long getSourceId() {
		return sourceId;
	}

	public void setSourceId(Long sourceId) {
		this.sourceId = sourceId;
	}

	public String getSourceType() {
		return sourceType;
	}

	public void setSourceType(String sourceType) {
		this.sourceType = sourceType;
	}

	public String getAppIds() {
		return appIds;
	}

	public void setAppIds(String appIds) {
		this.appIds = appIds;
	}

	public String getPlaces() {
		return places;
	}

	public void setPlaces(String places) {
		this.places = places;
	}

	public Date getExcuteTime() {
		return excuteTime;
	}

	public void setExcuteTime(Date excuteTime) {
		this.excuteTime = excuteTime;
	}

	public Integer getExcuteStatus() {
		return excuteStatus;
	}

	public void setExcuteStatus(Integer excuteStatus) {
		this.excuteStatus = excuteStatus;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}
}
