package cn.com.duiba.service.domain.vo;

import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;

import java.io.Serializable;
import java.util.Date;

/**
 * 封装 AppItemDO属性和 itemDO属性
 * 
 * @author houwen
 *
 */
public class AppItemVO implements Serializable {

	private static final long serialVersionUID = 6947802689549617526L;
	public static final int STATUS_USED = 1; // 已兑
	public static final int STATUS_NOREMAING = 2; // 兑完

	public static final int STATUS_LOTTERY = 3;// 抽奖
	public static final int MARK_NORMAL = 0;// 普通
	public static final int MARK_TIME = 1;// 秒杀
	public static final int MARK_QUANTITY = 2;// 限量
	public static final int MARK_LOTTERY = 3;// 抽奖
	public static final int MARK_ADDRLIMIT = 6;//地域限制

	/*** AppItemDO ****/
	private Long appItemId;
	private Long appItemAppId;
	private Long appItemItemId;
	private Long appItemBatchId;
	private Long appItemCredits;
	private Integer appItemMinFacePrice;
	private String appItemLogo;
	private String appItemTitle;
	private String appItemSubtitle;
	private Integer appItemPayload;
	private String appItemCustomPrice;
	private Date appItemAddTime;
	private Boolean appItemDeleted;
	private String appItemStatus;
	private String appItemSubStatus;
	private Boolean appItemHomeDisplay;
	private Boolean appItemIsOwner;
	private String appItemExchangeTipTemplate;
	private String appItemDescription;
	private Integer appItemFacePrice;
	private Integer appItemLimitCount;
	private Integer appItemRemaining;
	private Date appItemValidEndDate;
	private String appItemSmallImage;
	private String appItemImage;
	private String appItemMultiImage;
	private String appItemType;
	private Integer appItemSourceType;
	private Long appItemSourceRelationId;
	private String appItemLimitScope;
	private Integer appItemOperationsType;
	private String appItemLimitTimeBetween;
	private Integer appItemLimitEverydayQuantity;
	private String appItemBannerImage;
	private String appItemLimitDateJson;
	private Date appItemGmtCreate;
	private Date appItemGmtModified;

	/*** ItemDO ***/
	private Long itemId;
	private String itemTag;
	private String itemName;
	private String itemSubtitle;
	private String itemLogo;
	private String itemImage;
	private String itemMultiImage;
	private Integer itemFacePrice;
	private Integer itemActualPrice;
	private Long itemMinCredits;
	private Integer itemMinFacePrice;
	private String itemDescription;
	private Boolean itemSuggestDownload;
	private String itemIosOpen;
	private String itemIosDownload;
	private String itemAndroidDownload;
	private Boolean itemEnable;
	private Integer itemRemaining;
	private Integer itemSales;
	private Integer itemPayload;
	private String itemCustomPrice;
	private String itemSmallImage;
	private Integer itemLimitCount;
	private String itemLimitScope;
	private String itemType;
	private Integer itemTypeInt;
	private String itemExchangeTipTemplate;
	private Long itemOwnerAppId;
	private Long itemBatchId;
	private Date itemValidStartDate;
	private Date itemValidEndDate;
	private Date itemPublishTime;
	private Boolean itemDeleted;
	private String itemProductPrice;
	private Boolean itemShutDown;
	private Boolean itemShowAlert;
	private String itemAlertMessage;
	private Integer itemDuibaType;
	private Boolean itemAutoRecommend;
	private Integer itemSubType;
	private String itemBannerImage;
	private Integer itemOperationsType;
	private String itemLimitTimeBetween;
	private Integer itemLimitEverydayQuantity;
	private String itemLimitDateJson;
	private Date itemGmtCreate;
	private Date itemGmtModified;

	/*** 扩展 ***/
	private Integer useStatus; // 使用状态
	private Integer mark; // 角标
	
	//埋点使用
	private String info;
	private String infoType;

	public String getInfo() {
		return info;
	}

	public void setInfo(String info) {
		this.info = info;
	}

	public String getInfoType() {
		return infoType;
	}

	public void setInfoType(String infoType) {
		this.infoType = infoType;
	}

	public AppItemVO() {

	}

	/**
	 * ItemKey 构造 AppItemVO
	 * 
	 * @param itemKey
	 */
	public AppItemVO(ItemKey itemKey) {
		if (itemKey.getAppItem() != null) {
			AppItemDO appItem = itemKey.getAppItem();
			this.appItemAddTime = appItem.getAddTime();
			this.appItemAppId = appItem.getAppId();
			this.appItemBannerImage = appItem.getBannerImage();
			this.appItemBatchId = appItem.getBatchId();
			this.appItemCredits = appItem.getCredits();
			this.appItemCustomPrice = appItem.getCustomPrice();
			this.appItemDeleted = appItem.getDeleted();
			this.appItemDescription = appItem.getDescription();
			this.appItemExchangeTipTemplate = appItem.getExchangeTipTemplate();
			this.appItemFacePrice = appItem.getFacePrice();
			this.appItemGmtCreate = appItem.getGmtCreate();
			this.appItemGmtModified = appItem.getGmtModified();
			this.appItemHomeDisplay = appItem.getHomeDisplay();
			this.appItemId = appItem.getId();
			this.appItemImage = appItem.getImage();
			this.appItemIsOwner = appItem.getIsOwner();
			this.appItemItemId = appItem.getItemId();
			this.appItemLimitCount = appItem.getLimitCount();
			this.appItemLimitEverydayQuantity = appItem.getLimitEverydayQuantity();
			this.appItemLimitScope = appItem.getLimitScope();
			this.appItemLimitTimeBetween = appItem.getLimitTimeBetween();
			this.appItemLogo = appItem.getLogo();
			this.appItemMinFacePrice = appItem.getMinFacePrice();
			this.appItemMultiImage = appItem.getMultiImage();
			this.appItemOperationsType = appItem.getOperationsType();
			this.appItemPayload = appItem.getPayload();
			this.appItemRemaining = appItem.getRemaining();
			this.appItemSmallImage = appItem.getSmallImage();
			this.appItemSourceRelationId = appItem.getSourceRelationId();
			this.appItemSourceType = appItem.getSourceType();
			this.appItemStatus = appItem.getStatus();
			this.appItemSubStatus = appItem.getSubStatus();
			this.appItemSubtitle = appItem.getSubtitle();
			this.appItemTitle = appItem.getTitle();
			this.appItemType = appItem.getType();
			this.appItemValidEndDate = appItem.getValidEndDate();
			this.appItemLimitDateJson = appItem.getLimitDate();
		}
		if (itemKey.getItem() != null) {
			ItemDO item = itemKey.getItem();
			this.itemActualPrice = item.getActualPrice();
			this.itemAlertMessage = item.getAlertMessage();
			this.itemAndroidDownload = item.getAndroidDownload();
			this.itemAutoRecommend = item.getAutoRecommend();
			this.itemBannerImage = item.getBannerImage();
			this.itemBatchId = item.getBatchId();
			this.itemCustomPrice = item.getCustomPrice();
			this.itemDeleted = item.getDeleted();
			this.itemDescription = item.getDescription();
			this.itemDuibaType = item.getDuibaType();
			this.itemEnable = item.getEnable();
			this.itemExchangeTipTemplate = item.getExchangeTipTemplate();
			this.itemFacePrice = item.getFacePrice();
			this.itemGmtCreate = item.getGmtCreate();
			this.itemGmtModified = item.getGmtModified();
			this.itemId = item.getId();
			this.itemImage = item.getImage();
			this.itemIosDownload = item.getIosDownload();
			this.itemIosOpen = item.getIosOpen();
			this.itemLimitCount = item.getLimitCount();
			this.itemLimitEverydayQuantity = item.getLimitEverydayQuantity();
			this.itemLimitScope = item.getLimitScope();
			this.itemLimitTimeBetween = item.getLimitTimeBetween();
			this.itemLogo = item.getLogo();
			this.itemMinCredits = item.getMinCredits();
			this.itemMinFacePrice = item.getMinFacePrice();
			this.itemMultiImage = item.getMultiImage();
			this.itemName = item.getName();
			this.itemOperationsType = item.getOperationsType();
			this.itemOwnerAppId = item.getOwnerAppId();
			this.itemPayload = item.getPayload();
			this.itemProductPrice = item.getProductPrice();
			this.itemPublishTime = item.getPublishTime();
			this.itemRemaining = item.getRemaining();
			this.itemSales = item.getSales();
			this.itemShowAlert = item.getShowAlert();
			this.itemShutDown = item.getShutDown();
			this.itemSmallImage = item.getSmallImage();
			this.itemSubtitle = item.getSubtitle();
			this.itemSubType = item.getSubType();
			this.itemSuggestDownload = item.getSuggestDownload();
			this.itemTag = item.getTag();
			this.itemType = item.getType();
			this.itemTypeInt = item.getTypeInt();
			this.itemValidEndDate = item.getValidEndDate();
			this.itemValidStartDate = item.getValidStartDate();
			this.itemLimitDateJson = item.getLimitDate();
		}
	}

	/**
	 * AppItemVO 获取 ItemDO
	 * 
	 * @return
	 */
	public ItemDO getItemDO() {
		ItemDO itemDO = null;
		if (itemId != null) {
			itemDO = new ItemDO();
			itemDO.setId(itemId);
			itemDO.setTag(itemTag);
			itemDO.setName(itemName);
			itemDO.setSubtitle(itemSubtitle);
			itemDO.setLogo(itemLogo);
			itemDO.setImage(itemImage);
			itemDO.setMultiImage(itemMultiImage);
			itemDO.setFacePrice(itemFacePrice);
			itemDO.setActualPrice(itemActualPrice);
			itemDO.setMinCredits(itemMinCredits);
			itemDO.setMinFacePrice(itemMinFacePrice);
			itemDO.setDescription(itemDescription);
			itemDO.setSuggestDownload(itemSuggestDownload);
			itemDO.setIosOpen(itemIosOpen);
			itemDO.setIosDownload(itemIosDownload);
			itemDO.setAndroidDownload(itemAndroidDownload);
			itemDO.setEnable(itemEnable);
			itemDO.setRemaining(itemRemaining);
			itemDO.setSales(itemSales);
			itemDO.setPayload(itemPayload);
			itemDO.setCustomPrice(itemCustomPrice);
			itemDO.setSmallImage(itemSmallImage);
			itemDO.setLimitCount(itemLimitCount);
			itemDO.setLimitScope(itemLimitScope);
			itemDO.setType(itemType);
			itemDO.setTypeInt(itemTypeInt);
			itemDO.setExchangeTipTemplate(itemExchangeTipTemplate);
			itemDO.setOwnerAppId(itemOwnerAppId);
			itemDO.setBatchId(itemBatchId);
			itemDO.setValidStartDate(itemValidStartDate);
			itemDO.setValidEndDate(itemValidEndDate);
			itemDO.setPublishTime(itemPublishTime);
			itemDO.setDeleted(itemDeleted);
			itemDO.setProductPrice(itemProductPrice);
			itemDO.setShutDown(itemShutDown);
			itemDO.setShowAlert(itemShowAlert);
			itemDO.setAlertMessage(itemAlertMessage);
			itemDO.setDuibaType(itemDuibaType);
			itemDO.setAutoRecommend(itemAutoRecommend);
			itemDO.setSubType(itemSubType);
			itemDO.setBannerImage(itemBannerImage);
			itemDO.setOperationsType(itemOperationsType);
			itemDO.setLimitTimeBetween(itemLimitTimeBetween);
			itemDO.setLimitEverydayQuantity(itemLimitEverydayQuantity);
			itemDO.setLimitDate(itemLimitDateJson);
			itemDO.setGmtCreate(itemGmtCreate);
			itemDO.setGmtModified(itemGmtModified);
		}
		return itemDO;
	}

	/**
	 * AppItemVO 获取 AppItemDO
	 * 
	 * @return
	 */
	public AppItemDO getAppItemDO() {
		AppItemDO appItemDO = null;
		if (appItemId != null) {
			appItemDO = new AppItemDO();
			appItemDO.setId(appItemId);
			appItemDO.setAppId(appItemAppId);
			appItemDO.setItemId(appItemItemId);
			appItemDO.setBatchId(appItemBatchId);
			appItemDO.setCredits(appItemCredits);
			appItemDO.setMinFacePrice(appItemMinFacePrice);
			appItemDO.setLogo(appItemLogo);
			appItemDO.setTitle(appItemTitle);
			appItemDO.setSubtitle(appItemSubtitle);
			appItemDO.setPayload(appItemPayload);
			appItemDO.setCustomPrice(appItemCustomPrice);
			appItemDO.setAddTime(appItemAddTime);
			appItemDO.setDeleted(appItemDeleted);
			appItemDO.setStatus(appItemStatus);
			appItemDO.setSubStatus(appItemSubStatus);
			appItemDO.setHomeDisplay(appItemHomeDisplay);
			appItemDO.setIsOwner(appItemIsOwner);
			appItemDO.setExchangeTipTemplate(appItemExchangeTipTemplate);
			appItemDO.setDescription(appItemDescription);
			appItemDO.setFacePrice(appItemFacePrice);
			appItemDO.setLimitCount(appItemLimitCount);
			appItemDO.setRemaining(appItemRemaining);
			appItemDO.setValidEndDate(appItemValidEndDate);
			appItemDO.setSmallImage(appItemSmallImage);
			appItemDO.setImage(appItemImage);
			appItemDO.setMultiImage(appItemMultiImage);
			appItemDO.setType(appItemType);
			appItemDO.setSourceType(appItemSourceType);
			appItemDO.setSourceRelationId(appItemSourceRelationId);
			appItemDO.setLimitScope(appItemLimitScope);
			appItemDO.setOperationsType(appItemOperationsType);
			appItemDO.setLimitTimeBetween(appItemLimitTimeBetween);
			appItemDO.setLimitEverydayQuantity(appItemLimitEverydayQuantity);
			appItemDO.setBannerImage(appItemBannerImage);
			appItemDO.setLimitDate(appItemLimitDateJson);
			appItemDO.setGmtCreate(appItemGmtCreate);
			appItemDO.setGmtModified(appItemGmtModified);
		}
		return appItemDO;
	}

	public Long getAppItemId() {
		return appItemId;
	}

	public void setAppItemId(Long appItemId) {
		this.appItemId = appItemId;
	}

	public Long getAppItemAppId() {
		return appItemAppId;
	}

	public void setAppItemAppId(Long appItemAppId) {
		this.appItemAppId = appItemAppId;
	}

	public Long getAppItemItemId() {
		return appItemItemId;
	}

	public void setAppItemItemId(Long appItemItemId) {
		this.appItemItemId = appItemItemId;
	}

	public Long getAppItemBatchId() {
		return appItemBatchId;
	}

	public void setAppItemBatchId(Long appItemBatchId) {
		this.appItemBatchId = appItemBatchId;
	}

	public Long getAppItemCredits() {
		return appItemCredits;
	}

	public void setAppItemCredits(Long appItemCredits) {
		this.appItemCredits = appItemCredits;
	}

	public Integer getAppItemMinFacePrice() {
		return appItemMinFacePrice;
	}

	public void setAppItemMinFacePrice(Integer appItemMinFacePrice) {
		this.appItemMinFacePrice = appItemMinFacePrice;
	}

	public String getAppItemLogo() {
		return appItemLogo;
	}

	public void setAppItemLogo(String appItemLogo) {
		this.appItemLogo = appItemLogo;
	}

	public String getAppItemTitle() {
		return appItemTitle;
	}

	public void setAppItemTitle(String appItemTitle) {
		this.appItemTitle = appItemTitle;
	}

	public String getAppItemSubtitle() {
		return appItemSubtitle;
	}

	public void setAppItemSubtitle(String appItemSubtitle) {
		this.appItemSubtitle = appItemSubtitle;
	}

	public Integer getAppItemPayload() {
		return appItemPayload;
	}

	public void setAppItemPayload(Integer appItemPayload) {
		this.appItemPayload = appItemPayload;
	}

	public String getAppItemCustomPrice() {
		return appItemCustomPrice;
	}

	public void setAppItemCustomPrice(String appItemCustomPrice) {
		this.appItemCustomPrice = appItemCustomPrice;
	}

	public Date getAppItemAddTime() {
		return appItemAddTime;
	}

	public void setAppItemAddTime(Date appItemAddTime) {
		this.appItemAddTime = appItemAddTime;
	}

	public Boolean getAppItemDeleted() {
		return appItemDeleted;
	}

	public void setAppItemDeleted(Boolean appItemDeleted) {
		this.appItemDeleted = appItemDeleted;
	}

	public String getAppItemStatus() {
		return appItemStatus;
	}

	public void setAppItemStatus(String appItemStatus) {
		this.appItemStatus = appItemStatus;
	}

	public String getAppItemSubStatus() {
		return appItemSubStatus;
	}

	public void setAppItemSubStatus(String appItemSubStatus) {
		this.appItemSubStatus = appItemSubStatus;
	}

	public Boolean getAppItemHomeDisplay() {
		return appItemHomeDisplay;
	}

	public void setAppItemHomeDisplay(Boolean appItemHomeDisplay) {
		this.appItemHomeDisplay = appItemHomeDisplay;
	}

	public Boolean getAppItemIsOwner() {
		return appItemIsOwner;
	}

	public void setAppItemIsOwner(Boolean appItemIsOwner) {
		this.appItemIsOwner = appItemIsOwner;
	}

	public String getAppItemExchangeTipTemplate() {
		return appItemExchangeTipTemplate;
	}

	public void setAppItemExchangeTipTemplate(String appItemExchangeTipTemplate) {
		this.appItemExchangeTipTemplate = appItemExchangeTipTemplate;
	}

	public String getAppItemDescription() {
		return appItemDescription;
	}

	public void setAppItemDescription(String appItemDescription) {
		this.appItemDescription = appItemDescription;
	}

	public Integer getAppItemFacePrice() {
		return appItemFacePrice;
	}

	public void setAppItemFacePrice(Integer appItemFacePrice) {
		this.appItemFacePrice = appItemFacePrice;
	}

	public Integer getAppItemLimitCount() {
		return appItemLimitCount;
	}

	public void setAppItemLimitCount(Integer appItemLimitCount) {
		this.appItemLimitCount = appItemLimitCount;
	}

	public Integer getAppItemRemaining() {
		return appItemRemaining;
	}

	public void setAppItemRemaining(Integer appItemRemaining) {
		this.appItemRemaining = appItemRemaining;
	}

	public Date getAppItemValidEndDate() {
		return appItemValidEndDate;
	}

	public void setAppItemValidEndDate(Date appItemValidEndDate) {
		this.appItemValidEndDate = appItemValidEndDate;
	}

	public String getAppItemSmallImage() {
		return appItemSmallImage;
	}

	public void setAppItemSmallImage(String appItemSmallImage) {
		this.appItemSmallImage = appItemSmallImage;
	}

	public String getAppItemImage() {
		return appItemImage;
	}

	public void setAppItemImage(String appItemImage) {
		this.appItemImage = appItemImage;
	}

	public String getAppItemMultiImage() {
		return appItemMultiImage;
	}

	public void setAppItemMultiImage(String appItemMultiImage) {
		this.appItemMultiImage = appItemMultiImage;
	}

	public String getAppItemType() {
		return appItemType;
	}

	public void setAppItemType(String appItemType) {
		this.appItemType = appItemType;
	}

	public Integer getAppItemSourceType() {
		return appItemSourceType;
	}

	public void setAppItemSourceType(Integer appItemSourceType) {
		this.appItemSourceType = appItemSourceType;
	}

	public Long getAppItemSourceRelationId() {
		return appItemSourceRelationId;
	}

	public void setAppItemSourceRelationId(Long appItemSourceRelationId) {
		this.appItemSourceRelationId = appItemSourceRelationId;
	}

	public String getAppItemLimitScope() {
		return appItemLimitScope;
	}

	public void setAppItemLimitScope(String appItemLimitScope) {
		this.appItemLimitScope = appItemLimitScope;
	}

	public Integer getAppItemOperationsType() {
		return appItemOperationsType;
	}

	public void setAppItemOperationsType(Integer appItemOperationsType) {
		this.appItemOperationsType = appItemOperationsType;
	}

	public String getAppItemLimitTimeBetween() {
		return appItemLimitTimeBetween;
	}

	public void setAppItemLimitTimeBetween(String appItemLimitTimeBetween) {
		this.appItemLimitTimeBetween = appItemLimitTimeBetween;
	}

	public Integer getAppItemLimitEverydayQuantity() {
		return appItemLimitEverydayQuantity;
	}

	public void setAppItemLimitEverydayQuantity(Integer appItemLimitEverydayQuantity) {
		this.appItemLimitEverydayQuantity = appItemLimitEverydayQuantity;
	}

	public String getAppItemBannerImage() {
		return appItemBannerImage;
	}

	public void setAppItemBannerImage(String appItemBannerImage) {
		this.appItemBannerImage = appItemBannerImage;
	}

	public Date getAppItemGmtCreate() {
		return appItemGmtCreate;
	}

	public void setAppItemGmtCreate(Date appItemGmtCreate) {
		this.appItemGmtCreate = appItemGmtCreate;
	}

	public Date getAppItemGmtModified() {
		return appItemGmtModified;
	}

	public void setAppItemGmtModified(Date appItemGmtModified) {
		this.appItemGmtModified = appItemGmtModified;
	}

	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public String getItemTag() {
		return itemTag;
	}

	public void setItemTag(String itemTag) {
		this.itemTag = itemTag;
	}

	public String getItemName() {
		return itemName;
	}

	public void setItemName(String itemName) {
		this.itemName = itemName;
	}

	public String getItemSubtitle() {
		return itemSubtitle;
	}

	public void setItemSubtitle(String itemSubtitle) {
		this.itemSubtitle = itemSubtitle;
	}

	public String getItemLogo() {
		return itemLogo;
	}

	public void setItemLogo(String itemLogo) {
		this.itemLogo = itemLogo;
	}

	public String getItemImage() {
		return itemImage;
	}

	public void setItemImage(String itemImage) {
		this.itemImage = itemImage;
	}

	public String getItemMultiImage() {
		return itemMultiImage;
	}

	public void setItemMultiImage(String itemMultiImage) {
		this.itemMultiImage = itemMultiImage;
	}

	public Integer getItemFacePrice() {
		return itemFacePrice;
	}

	public void setItemFacePrice(Integer itemFacePrice) {
		this.itemFacePrice = itemFacePrice;
	}

	public Integer getItemActualPrice() {
		return itemActualPrice;
	}

	public void setItemActualPrice(Integer itemActualPrice) {
		this.itemActualPrice = itemActualPrice;
	}

	public Long getItemMinCredits() {
		return itemMinCredits;
	}

	public void setItemMinCredits(Long itemMinCredits) {
		this.itemMinCredits = itemMinCredits;
	}

	public Integer getItemMinFacePrice() {
		return itemMinFacePrice;
	}

	public void setItemMinFacePrice(Integer itemMinFacePrice) {
		this.itemMinFacePrice = itemMinFacePrice;
	}

	public String getItemDescription() {
		return itemDescription;
	}

	public void setItemDescription(String itemDescription) {
		this.itemDescription = itemDescription;
	}

	public Boolean getItemSuggestDownload() {
		return itemSuggestDownload;
	}

	public void setItemSuggestDownload(Boolean itemSuggestDownload) {
		this.itemSuggestDownload = itemSuggestDownload;
	}

	public String getItemIosOpen() {
		return itemIosOpen;
	}

	public void setItemIosOpen(String itemIosOpen) {
		this.itemIosOpen = itemIosOpen;
	}

	public String getItemIosDownload() {
		return itemIosDownload;
	}

	public void setItemIosDownload(String itemIosDownload) {
		this.itemIosDownload = itemIosDownload;
	}

	public String getItemAndroidDownload() {
		return itemAndroidDownload;
	}

	public void setItemAndroidDownload(String itemAndroidDownload) {
		this.itemAndroidDownload = itemAndroidDownload;
	}

	public Boolean getItemEnable() {
		return itemEnable;
	}

	public void setItemEnable(Boolean itemEnable) {
		this.itemEnable = itemEnable;
	}

	public Integer getItemRemaining() {
		return itemRemaining;
	}

	public void setItemRemaining(Integer itemRemaining) {
		this.itemRemaining = itemRemaining;
	}

	public Integer getItemSales() {
		return itemSales;
	}

	public void setItemSales(Integer itemSales) {
		this.itemSales = itemSales;
	}

	public Integer getItemPayload() {
		return itemPayload;
	}

	public void setItemPayload(Integer itemPayload) {
		this.itemPayload = itemPayload;
	}

	public String getItemCustomPrice() {
		return itemCustomPrice;
	}

	public void setItemCustomPrice(String itemCustomPrice) {
		this.itemCustomPrice = itemCustomPrice;
	}

	public String getItemSmallImage() {
		return itemSmallImage;
	}

	public void setItemSmallImage(String itemSmallImage) {
		this.itemSmallImage = itemSmallImage;
	}

	public Integer getItemLimitCount() {
		return itemLimitCount;
	}

	public void setItemLimitCount(Integer itemLimitCount) {
		this.itemLimitCount = itemLimitCount;
	}

	public String getItemLimitScope() {
		return itemLimitScope;
	}

	public void setItemLimitScope(String itemLimitScope) {
		this.itemLimitScope = itemLimitScope;
	}

	public String getItemType() {
		return itemType;
	}

	public void setItemType(String itemType) {
		this.itemType = itemType;
	}

	public Integer getItemTypeInt() {
		return itemTypeInt;
	}

	public void setItemTypeInt(Integer itemTypeInt) {
		this.itemTypeInt = itemTypeInt;
	}

	public String getItemExchangeTipTemplate() {
		return itemExchangeTipTemplate;
	}

	public void setItemExchangeTipTemplate(String itemExchangeTipTemplate) {
		this.itemExchangeTipTemplate = itemExchangeTipTemplate;
	}

	public Long getItemOwnerAppId() {
		return itemOwnerAppId;
	}

	public void setItemOwnerAppId(Long itemOwnerAppId) {
		this.itemOwnerAppId = itemOwnerAppId;
	}

	public Long getItemBatchId() {
		return itemBatchId;
	}

	public void setItemBatchId(Long itemBatchId) {
		this.itemBatchId = itemBatchId;
	}

	public Date getItemValidStartDate() {
		return itemValidStartDate;
	}

	public void setItemValidStartDate(Date itemValidStartDate) {
		this.itemValidStartDate = itemValidStartDate;
	}

	public Date getItemValidEndDate() {
		return itemValidEndDate;
	}

	public void setItemValidEndDate(Date itemValidEndDate) {
		this.itemValidEndDate = itemValidEndDate;
	}

	public Date getItemPublishTime() {
		return itemPublishTime;
	}

	public void setItemPublishTime(Date itemPublishTime) {
		this.itemPublishTime = itemPublishTime;
	}

	public Boolean getItemDeleted() {
		return itemDeleted;
	}

	public void setItemDeleted(Boolean itemDeleted) {
		this.itemDeleted = itemDeleted;
	}

	public String getItemProductPrice() {
		return itemProductPrice;
	}

	public void setItemProductPrice(String itemProductPrice) {
		this.itemProductPrice = itemProductPrice;
	}

	public Boolean getItemShutDown() {
		return itemShutDown;
	}

	public void setItemShutDown(Boolean itemShutDown) {
		this.itemShutDown = itemShutDown;
	}

	public Boolean getItemShowAlert() {
		return itemShowAlert;
	}

	public void setItemShowAlert(Boolean itemShowAlert) {
		this.itemShowAlert = itemShowAlert;
	}

	public String getItemAlertMessage() {
		return itemAlertMessage;
	}

	public void setItemAlertMessage(String itemAlertMessage) {
		this.itemAlertMessage = itemAlertMessage;
	}

	public Integer getItemDuibaType() {
		return itemDuibaType;
	}

	public void setItemDuibaType(Integer itemDuibaType) {
		this.itemDuibaType = itemDuibaType;
	}

	public Boolean getItemAutoRecommend() {
		return itemAutoRecommend;
	}

	public void setItemAutoRecommend(Boolean itemAutoRecommend) {
		this.itemAutoRecommend = itemAutoRecommend;
	}

	public Integer getItemSubType() {
		return itemSubType;
	}

	public void setItemSubType(Integer itemSubType) {
		this.itemSubType = itemSubType;
	}

	public String getItemBannerImage() {
		return itemBannerImage;
	}

	public void setItemBannerImage(String itemBannerImage) {
		this.itemBannerImage = itemBannerImage;
	}

	public Integer getItemOperationsType() {
		return itemOperationsType;
	}

	public void setItemOperationsType(Integer itemOperationsType) {
		this.itemOperationsType = itemOperationsType;
	}

	public String getItemLimitTimeBetween() {
		return itemLimitTimeBetween;
	}

	public void setItemLimitTimeBetween(String itemLimitTimeBetween) {
		this.itemLimitTimeBetween = itemLimitTimeBetween;
	}

	public Integer getItemLimitEverydayQuantity() {
		return itemLimitEverydayQuantity;
	}

	public void setItemLimitEverydayQuantity(Integer itemLimitEverydayQuantity) {
		this.itemLimitEverydayQuantity = itemLimitEverydayQuantity;
	}

	public Date getItemGmtCreate() {
		return itemGmtCreate;
	}

	public void setItemGmtCreate(Date itemGmtCreate) {
		this.itemGmtCreate = itemGmtCreate;
	}

	public Date getItemGmtModified() {
		return itemGmtModified;
	}

	public void setItemGmtModified(Date itemGmtModified) {
		this.itemGmtModified = itemGmtModified;
	}

	public String getAppItemLimitDateJson() {
		return appItemLimitDateJson;
	}

	public void setAppItemLimitDateJson(String appItemLimitDateJson) {
		this.appItemLimitDateJson = appItemLimitDateJson;
	}

	public String getItemLimitDateJson() {
		return itemLimitDateJson;
	}

	public void setItemLimitDateJson(String itemLimitDateJson) {
		this.itemLimitDateJson = itemLimitDateJson;
	}

	public Integer getUseStatus() {
		return useStatus;
	}

	public void setUseStatus(Integer useStatus) {
		this.useStatus = useStatus;
	}

	public Integer getMark() {
		return mark;
	}

	public void setMark(Integer mark) {
		this.mark = mark;
	}

}
