package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.DuibaRecommendQueueDO;
import cn.com.duiba.service.exception.BusinessException;

import java.util.List;

public interface RemoteDuibaRecommendQueueService {

	/**
	 * 删除
	 */
	public void delete(Long id);
	
	/**
	 * 删除
	 */
	public void deleteAll();

	/**
	 * 查询全部
	 */
	public List<DuibaRecommendQueueDO> findAll();
	
	/**
	 * 查询大于sort数据
	 */
	public List<DuibaRecommendQueueDO> findAllGTSort(Integer sort);

	
	public DuibaRecommendQueueDO insert(DuibaRecommendQueueDO duibaRecommendQueueDO);
	
	
	public DuibaRecommendQueueDO find(Long id);
	
	public DuibaRecommendQueueDO findByRelationIdAndRelationType(Long relationId, Integer relationType);
	
	public int updateBySort(Long id, Integer sort);

	/**
	 * 查询推荐位队列
	 */
	public List<AppItemDO> findRecommendAppItem(Long appId);

	//from DuibaRecommendQueueService in manager

	/**
	 * 把兑吧内容加入到兑吧推荐位中
	 *
	 * @throws Exception
	 */
	public void addIntoDuibaRecommendQueue(Long sourceId, Integer sourceType) throws BusinessException;

	public void deleteRecommend(Long id);
}
