package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.TurntableOrderDO;
import cn.com.duiba.service.domain.queryparams.ATurntableOrderQueryEntity;
import cn.com.duiba.service.domain.vo.DeveloperActivityStatisticsVO;
import cn.com.duiba.service.domain.vo.TurntableOrderVO;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/5/31.
 */
public interface RemoteTurntableOrderService {
    //from TurntableOrderSimpleDAOImpl

    /**
     * 根据ID查询订单
     */
    public TurntableOrderDO find(Long id);

    /**
     * 根据id集合查询幸运转盘订单
     */
    public List<TurntableOrderDO> findAllByIds(List<Long> ids);

    /**
     * 根据orderNum查询大转盘订单
     */
    public TurntableOrderDO findByOrderNum(String orderNum);

    /**
     * 根据订单id查询大转盘订单
     */
    public TurntableOrderDO findByOrderId(Long orderId);

    /**
     * 根据主订单id查询大转盘订单
     */
    public List<TurntableOrderDO> findByInOrderIds(List<Long> orderIds);

    /**
     * 根据开发者订单号查询
     */
    public TurntableOrderDO findByAppAndDeveloperBizId(Long appId, String developerBizId);

    /**
     * 分页统计条数
     */
    public Long findByCount(Map<String, Object> params);

    /**
     * 分页列表
     */
    public List<TurntableOrderVO> findByLimt(Map<String, Object> params);

    /**
     * 查询用户中奖个数
     */
    public Integer findCustomerWinNum(Long activityId, Long consumerId, Long optionId);

    /**
     * 获取领奖失败次数
     */
    public List<DeveloperActivityStatisticsVO> findFailCountByOperatingActivityIds(List<Long> operatingActivityIds);

    /**
     * 根据appId查询某段时间内大转盘成功订单积分
     */
    public Map<String, Long> findSumTurnTableCreditsByApp(Long appId, Date startDay, Date endDay);

    /**
     * 领奖异常分页列表展示
     */
    public List<TurntableOrderDO> findPageAdmin(ATurntableOrderQueryEntity queryEntity);

    /**
     * 领奖异常分页总数
     */
    public Long findPageCountAdmin(ATurntableOrderQueryEntity queryEntity);

    /**
     * 查询用户抽奖次数
     */
    public Integer findCustomerLotteryNum(Long activityId, Long consumerId, Date start, Date end);

    /**
     * 查询用户免费抽奖次数
     */
    public Integer findCustomerFreeLotteryNum(Long activityId, Long consumerId, Date start, Date end);

    /**
     * 查询用户抽奖次数,排除 再来一次
     */
    public Integer findCustomerLotteryNumNoTragin(Long operatingActivityId, Long consumerId, Date start, Date end);

    /**
     * 查询用户是否有抽过奖
     */
    public Integer findConsumerExistLottery(Long operatingActivityId, Long consumerId);

    /**
     * 查询创建时间小于 data的订单
     */
    public List<TurntableOrderDO> findAllByLtGmtCreateAndExchangeStatus();

    /**
     * 查询是否被大转盘使用
     * @param itemId
     * @return
     */
    public List<Long> findHasUserdTurntableIds(Long itemId);

    public List<TurntableOrderDO> findTurntableOrderLimit50(Long activityId);

    //from TurntableOrderStatusChangeDAOImpl

    /**
     * 修改订单领奖状态为失败
     */
    public int updateExchangeStatusToFail(long id, String error4admin, String error4developer, String error4consumer);

    /**
     * 修改订单领奖状态为过期失效
     */
    public int updateExchangeStatusToOverdue(long id, String error4admin, String error4developer, String error4consumer);

    /**
     * 修改订单状态成功，领奖状态待领奖
     */
    public int updateStatusToSuccess(long id);

    /**
     * 修改订单状态失败
     */
    public int updateStatusToFail(long id, String error4admin, String error4developer, String error4consumer);

    /**
     * 订单抽奖失败，修改为谢谢参与
     */
    public int updatePrizeTypeToThanks(long id);

    /**
     * 处理再来一次
     */
    public Integer doTryagin(Long id);

    /**
     * 处理领奖
     */
    public Integer doTakePrize(Long id);

    /**
     * 领奖失败回滚
     */
    public Integer rollbackTakePrize(Long id);

    /**
     * 修改订单抽奖结果
     */
    public Integer updateLotteryResult(Long id, Long appItemId, Long itemId, Long prizeId, String prizeName, Integer prizeType, String prizeDegree, Integer prizeFacePrice, Long couponId);

    //from TurntableOrderTextChangeDAOImpl

    /**
     * 修改开发者订单号
     */
    public int updateDeveloperBizId(long id, String bizId);

    /**
     * 修改主订单ID
     */
    public int updateMainOrderId(long id, Long orderId);

    /**
     * 添加幸运转盘订单
     */
    public TurntableOrderDO insert(TurntableOrderDO turntableOrderDO);
}
