package cn.com.duiba.service.remoteservice;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.service.domain.dataobject.TurntableOrderDO;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.exception.StatusException;

/**
 * 大转盘奖项库存操作
 * @author zp
 *
 * from TurntableStockOperateService
 *
 */
public interface RemoteTurntableService {

	//方法来自TurntableService from manager
	public void saveOrUpdateDuibaTurntableOptions(Long turntableId, Long[] id, String[] type, String[] logo, Long[] itemId, String[] rate, Integer[] limitCount, Integer[] minComein, Integer[] remaining, Integer[] preRemaining, Integer[] facePrice, String[] name) throws BusinessException;

	/**
	 * 删除大转盘活动
	 *
	 * @param id
	 * @param appId
	 */
	public OperatingActivityDto deleteTurntable(Long id, Long appId);

	/**
	 * 来自DevTurntableCtrl.saveTurntable
	 * 把原来的saveOrUpdateTurntable和saveOrUpdateTurntableOptions合并成如下这句,以放在一个事务内
	 *
	 * @throws BusinessException
	 */
	public void saveTurntable(OperatingActivityDto activity, Long appId, Long[] id, String[] type, String[] logo, Long[] appItemId, String[] rate, Integer[] limitCount, Integer[] minComein, Integer[] remaining, Integer[] preRemaining, Integer[] facePrice, String[] prizeDegree, String[] name) throws BusinessException;

	/**
	 * from TurntableService.returnTurntableLotteryStock in credits
	 * @param to
	 */
	public void returnTurntableLotteryStockInner(TurntableOrderDO to) throws BusinessException, StatusException;
}
