package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.ConsumerFootprintDO;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by xuezhaoming on 16/5/11.
 */
public interface RemoteConsumerFootPrintService {

    /**
     * 根据消费者ID优先从缓存中查询,若是不存在,从数据库中查询并放入缓存
     * 
     * @param consumerId
     * @return 返回整个的实体
     */
    DubboResult<ConsumerFootprintDO> findByConsumerId(Long consumerId);

    /**
     * 根据消费者ID,查询制定字段的数据
     * 
     * @param consumerId 消费者ID
     * @param column 期望返回的字段
     * @return
     */
    DubboResult<ConsumerFootprintDO> findByColumnAndConsumerId(Long consumerId, String column);

    /**
     * 根据消费者ID更新用户足迹,并失效缓存
     * 
     * @param consumerFootprintDO
     * @return 影响的条数
     */
    DubboResult<Integer> updateByConsumerId(ConsumerFootprintDO consumerFootprintDO);

    /**
     * 根据主键ID更新用户足迹,并失效缓存
     * 
     * @param consumerFootprintDO
     * @return
     */
    DubboResult<Integer> update(ConsumerFootprintDO consumerFootprintDO);

    /**
     * 插入新的用户足迹
     * 
     * @param consumerFootprintDO
     */
    void insert(ConsumerFootprintDO consumerFootprintDO);

}
