package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dto.ActivityOrdersDto;
import cn.com.duiba.service.domain.dto.OrdersDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * Created by yansen on 16/7/20.
 */
public interface RemoteOrdersReadService {

    DubboResult<List<OrdersDto>> findPageByDeveloperBizId(int offset, int max, String developerBizId);

    DubboResult<Long> getCountByDeveloperBizId(String developerBizId);

    DubboResult<List<ActivityOrdersDto>> findActivityOrdersPageForAdmin(Map<String, Object> queryMap);

    DubboResult<Integer> findActivityOrdersPageCountForAdmin(Map<String, Object> queryMap);

    DubboResult<Integer> countItemNum(long itemId, Date startTime);

    DubboResult<List<Long>> findWaitAuditOrders(Map<String, Object> queryMap);

    //待发货订单
    DubboResult<List<Long>> findWaitShippOrders(Map<String, Object> queryMap);

    //超时订单
    DubboResult<List<Long>> findTimeoutOrders(Map<String, Object> queryMap);

    //抽奖超时订单
    DubboResult<List<Long>> findLotteryTimeoutOrders(Map<String, Object> queryMap);

    //虚拟商品异常订单
    DubboResult<List<Long>> findVirtualOrders(Map<String, Object> queryMap);

    //秒杀订单
    DubboResult<List<Long>> findKillOrders(Map<String, Object> queryMap);


}
