package cn.com.duiba.duiba.stormrage.center.api.remoteservice.risk;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.stormrage.center.common.dto.risk.StormBlackListDto;
import cn.com.duiba.duiba.stormrage.center.common.param.RiskBlackListParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 风控黑名单服务-面向系统 ClassName: RemoteStormRiskBlackListService <br/>
 */
@AdvancedFeignClient
public interface RemoteStormRiskBlackListService {

    /**
     * 根据主键删除操作
     *
     * @param id
     * @return
     */
    int deleteByPrimaryKey(Long id);

    /**
     * 根据主键删除操作
     *
     * @return
     */
    void batchDeleteByPrimaryKey(List<Long> ids);

    /**
     * 插入操作
     *
     * @param record
     * @return
     */
    Long insert(StormBlackListDto record);

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    StormBlackListDto selectByPrimaryKey(Long id);

    /**
     * 更新操作（空值不更新）
     *
     * @param record
     * @return
     */
    int updateByPrimaryKeySelective(StormBlackListDto record);

    /**
     * 批量新增
     *
     * @param list
     * @return
     */
    int batchInsert(List<StormBlackListDto> list);

    /**
     * 分页查询
     *
     * @param riskBlackListParam
     * @return
     */
    PageResponse<StormBlackListDto> listByPage(RiskBlackListParam riskBlackListParam);

    /**
     * 查询数据库是否唯一键冲突
     *
     * @return
     */
    Boolean checkOnly(Long id, Long appId, Integer riskType, Integer riskScene, String riskValue);


    /**
     * 批量查询
     * @param appId
     * @param riskType
     * @param riskScene
     * @param riskValues
     * @return
     */
    List<StormBlackListDto> selectByMultValues(Long appId, Integer riskType, Integer riskScene, List<String> riskValues);


    /**
     * 用户当天临时解封
     * @param consumerId
     * @return
     */
    void unsealAccount(Long consumerId);

}
