package cn.com.duiba.duiba.stormrage.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.stormrage.center.common.dto.EngineRuleDto;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

@AdvancedFeignClient
public interface RemoteEngineRuleService {

    /**
     * 新增规则引擎规则信息
     * @param dto
     */
    void save(EngineRuleDto dto);

    /**
     * 更新规则引擎规则信息
     * @param dto
     */
    void update(EngineRuleDto dto);

    /**
     * 更新状态
     * @param id
     * @param status
     * @param editor
     */
    void updateStatus(Long id, Integer status, String editor);

    /**
     * 删除规则引擎规则信息
     * @param id
     * @param editor
     */
    void delete(Long id, String editor);

    /**
     * 规则引擎规则分页查询
     * @param strategyId
     * @param ruleName
     * @param status
     * @param pageIndex
     * @param pageSize
     * @return
     */
    PageResponse<EngineRuleDto> queryPage(Long strategyId, String ruleName, Integer status, int pageIndex, Integer pageSize);

    /**
     * 根据strategyId查询所属规则
     * @param strategyId
     * @return
     */
    List<EngineRuleDto> getByStrategyId(Long strategyId);

    /**
     * 查询所有规则
     * @return
     */
    List<EngineRuleDto> getAllRules();

    /**
     * 根据ID
     * @param ruleId
     * @return
     */
    EngineRuleDto getRuleById(Long ruleId);

    /**
     * 校验规则名称在该策略下是否重复
     * @param ruleName
     * @param sId
     * @param ruleId
     * @return
     */
    boolean checkRuleNameByStrategyId(String ruleName, Long sId, Long ruleId);

    /**
     * 根据场景id查询规则信息
     *
     * @param sceneId
     * @return
     */
    List<EngineRuleDto> getRuleBySceneId(Long sceneId);

    /**
     * 根据规则ID列表查询规则数据
     * @param ruleIds
     * @return
     */
    List<EngineRuleDto> getRulesByIds(List<Long> ruleIds);

    /**
     * 从某个策略下复制所有规则
     * @param sId
     * @param tId
     */
    void copyRulesFromStrategy(Long sId, Long tId, String editor) throws BizException;
}
