package cn.com.duiba.duiba.stormrage.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.stormrage.center.common.dto.EngineSceneDto;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 规则引擎场景信息服务 ClassName: RemoteEngineSceneService
 */
@AdvancedFeignClient
public interface RemoteEngineSceneService {


    /**
     * 分页查询规则引擎场景信息
     * @param sceneName
     * @param pageIndex
     * @param pageSize
     * @return
     */
    PageResponse<EngineSceneDto> queryPage(String sceneName, int pageIndex, Integer pageSize);

    /**
     * 新增规则引擎场景信息
     * @param dto
     * @return
     */
    Integer save(EngineSceneDto dto);

    /**
     * @Description: 更新规则引擎场景信息
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/7/23
     */
    Integer update(EngineSceneDto dto);

    /**
     * 删除规则引擎场景信息
     * @param dto
     * @return
     */
    Integer delete(EngineSceneDto dto);

    /**
     * 根据id或全量查询规则引擎场景名称
     * @param ids
     * @return
     */
    List<EngineSceneDto> queryAllScene(List<Long> ids);

    /**
     * 校验场景名称，场景标识是否重复
     * @param dto
     * @return
     */
    Boolean checkSceneKeyOrName(EngineSceneDto dto);

    /**
     * 校验场景名称，场景标识是否重复
     * @param key
     * @return
     */
    EngineSceneDto getByKey(String key);

    /**
     * 根据场景标识查询兑吧场景
     * @param sceneKey
     * @return
     */
    List<EngineSceneDto> getDuiBaSceneByKey(String sceneKey);
}
