package cn.com.duiba.duiba.stormrage.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.stormrage.center.common.dto.EngineStrategyDto;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.Collection;
import java.util.List;

@AdvancedFeignClient
public interface RemoteEngineStrategyService {

    /**
     *  新增规则引擎策略信息
     * @param strategy
     * @return
     */
    Integer save(EngineStrategyDto strategy);

    /**
     *  更新规则引擎策略信息
     * @param strategy
     * @return
     */
    Integer update(EngineStrategyDto strategy);

    /**
     * 通过ID删除规则引擎策略信息
     * @param id
     * @return
     */
    Integer delete(long id);

    /**
     * 通过Key删除规则引擎策略信息
     * @param key
     * @return
     */
    Integer deleteByKey(String key);

    /**
     * 通过ID列表，批量删除
     * @param ids
     * @return
     */
    Integer deleteBatchById(Collection<Long> ids);

    /**
     * 规则引擎策略分页查询
     * @param sceneId
     * @param strategyName
     * @param pageIndex
     * @param pageSize
     * @return
     */
    PageResponse<EngineStrategyDto> queryPage(Long sceneId,String strategyName, int pageIndex, Integer pageSize);

    /**
     * 查询所有策略
     * @param sceneId
     * @return
     */
    List<EngineStrategyDto> queryAll(Long sceneId);

    /**
     * 根据策略名称查询
     * @param name
     * @return
     */
    EngineStrategyDto getByName(String name);

    /**
     * 根据策略Key查询
     * @param key
     * @return
     */
    EngineStrategyDto getByKey(String key);


    /**
     * 校验策略名称，策略标识是否重复
     * @param dto
     * @return
     */
    Boolean checkStrategyKeyOrName(EngineStrategyDto dto);

}
