package cn.com.duiba.duiba.stormrage.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.stormrage.center.common.dto.EngineConditionDto;
import cn.com.duiba.duiba.stormrage.center.common.dto.EngineFieldDto;
import cn.com.duiba.duiba.stormrage.center.common.dto.statistics.*;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.Date;
import java.util.List;

/**
 * 怒风离线数据统计报表服务 ClassName: RemoteStatisticsDmService <br/>
 */
@AdvancedFeignClient
public interface RemoteStatisticsDmService {

    /**
     * 通过日期与平台查询怒风拦截活动TOP10
     * @param curDate
     * @param platform
     * @return
     */
    List<DmStormrageDailyDiDto> getTop10ByDateAndPlatform(Date curDate, String platform);



    /**
     * 通过日期查询怒风积分商城活动ip异常日统计表TOP10
     * @param curDate
     * @return
     */
    List<DmDuibaJfscActivityAnomalyIpDiDto> getTop10ByDateJfscIp(Date curDate);

    /**
     * 通过日期查询怒风积分商城活动参与异常日统计表TOP10
     * @param curDate
     * @return
     */
    List<DmDuibaJfscActivityJoinAnomalyDiDto> getTop10ByDateJfscJoin(Date curDate);


    /**
     * 通过日期查询怒风星速台活动参与异常日统计表TOP10
     * @param curDate
     * @return
     */
    List<DmDuibaProjectActivityAnomalyIpDiDto> getTop10ByDateProjectIp(Date curDate);



    /**
     * 通过日期查询怒风星速台参与异常日统计表TOP10
     * @param curDate
     * @return
     */
    List<DmDuibaProjectActivityJoinAnomalyDiDto> getTop10ByDateProjectJoin(Date curDate);




}
