package cn.com.duiba.duiba.stormrage.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.stormrage.center.common.dto.EngineConditionDto;
import cn.com.duiba.duiba.stormrage.center.common.dto.EngineFieldDto;
import cn.com.duiba.duiba.stormrage.center.common.dto.UniBlacklistRouteDto;
import cn.com.duiba.duiba.stormrage.center.common.dto.UniversalBlacklistDto;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 通用IP黑名单路由配置
 */
@AdvancedFeignClient
public interface RemoteUniBlacklistRouteService {

    /**
     * @Description: 分页查询
     * @Param:
     * @return:
     */
    PageResponse<UniBlacklistRouteDto> queryPage(Long appId, Integer sceneType, int pageIndex, Integer pageSize);

    /**
     * @Description: 新增
     * @Param:
     * @return:
     */
    Integer save(UniBlacklistRouteDto dto);

    /**
     * @Description: 更新
     * @Param:
     * @return:
     */
    Integer update(UniBlacklistRouteDto dto);

    /**
     * @Description: 删除
     * @Param:
     * @return:
     */
    Integer delete(Long id);

    /**
     * 根据ID获取对象
     * @param id
     * @return
     */
    UniBlacklistRouteDto getById(Long id);


    /**
     * @Description: 校验是否存在重复APPID与场景类型组合
     * @Param:
     * @return:  ture 重复
     */
    Boolean checkAppIdSceneTypeExist(UniBlacklistRouteDto dto);

}
