package cn.com.duiba.duiba.stormrage.center.common.constants;


import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 条件比较符
 */
public enum CompareSymbol {

    GT(0, (v, t) -> v.doubleValue() > t[0].doubleValue(), null, ">"),
    LT(1, (v, t) -> v.doubleValue() < t[0].doubleValue(), null, "<"),
    EQ(2, (v, t) -> Objects.equals(v, t[0]), (v, t) -> Objects.equals(v, t[0]), "="),
    GTE(3, (v, t) -> v.doubleValue() >= t[0].doubleValue(), null, ">="),
    LTE(4, (v, t) -> v.doubleValue() <= t[0].doubleValue(), null, "<="),
    NEQ(5, (v, t) -> !Objects.equals(v, t[0]), (v, t) -> !Objects.equals(v, t[0]), "!="),
    GT_LTE(6, (v, t) -> v.doubleValue() > t[0].doubleValue() && v.doubleValue() <= t[1].doubleValue(), null, ">", "<="),
    GT_LT(7, (v, t) -> v.doubleValue() > t[0].doubleValue() && v.doubleValue() < t[1].doubleValue(), null, ">", "<"),
    GTE_LT(8, (v, t) -> v.doubleValue() >= t[0].doubleValue() && v.doubleValue() < t[1].doubleValue(), null, ">=", "<"),
    GTE_LTE(9, (v, t) -> v.doubleValue() >= t[0].doubleValue() && v.doubleValue() <= t[1].doubleValue(), null, ">=", "<="),
    CONTAINS(10, null, (v, t) -> v.contains(t[0]), "contains"),
    NOT_CONTAINS(11, null, (v, t) -> !v.contains(t[0]), "not contains"),;

    public int getCode() {
        return code;
    }

    public String[] getSymbols() {
        return symbols;
    }

    private int code;

    private String[] symbols;

    private NumComparator numComparator;

    private StrComparator strComparator;

    CompareSymbol(int code, NumComparator comparator, StrComparator strComparator, String... symbols) {
        this.code = code;
        this.symbols = symbols;
        this.numComparator = comparator;
        this.strComparator = strComparator;
    }

    public <T> boolean compare(T value, T... threshold) {
        if (value instanceof Number && threshold instanceof Number[]) {
            return this.numComparator.apply((Number) value, (Number[]) threshold);
        } else if (value instanceof String && threshold instanceof String[]) {
            return this.strComparator.apply((String) value, (String[]) threshold);
        } else {
            return false;
        }
    }

    @FunctionalInterface
    interface NumComparator<T extends Number> {
        boolean apply(T value, T... target);
    }

    @FunctionalInterface
    interface StrComparator {
        boolean apply(String value, String... target);
    }

    static Map<Integer, CompareSymbol> symbolMap;

    static {
        symbolMap = Arrays.stream(CompareSymbol.values())
                .collect(Collectors.toMap(CompareSymbol::getCode, Function.identity()));
    }

    public static CompareSymbol getSymbolByCode(int code) {
        return symbolMap.get(code);
    }

}
