package cn.com.duiba.duiba.stormrage.center.common.param;

import cn.com.duiba.duiba.stormrage.center.common.enums.ActRiskSenceEnum;
import cn.com.duiba.duiba.stormrage.center.common.enums.RiskWhiteListTypeEnum;
import lombok.Data;

import java.util.List;

/**
 * 风控白名单入参
 * @author chenyongkun
 * @date 2023/3/14
 */
@Data
public class RiskWhiteListParam {

    private static final long serialVersionUID = -2634626519754817768L;

    //  appIds
    private List<Long> appIds;
    //用户id
    private Long consumerId;
    //1 应用白名单，2 用户白名单，3IP白名单
    private RiskWhiteListTypeEnum riskType;
    //风控场景：1 提现，2 参与，3 发奖
    private ActRiskSenceEnum riskSence;
    //IP地址检索
    private String ip;

    private Integer pageNo = 1;

    private Integer pageSize = 20;
}
