package cn.com.duiba.duiba.stormrage.center.common.param;

import lombok.Data;

import java.util.Date;

/**
 * 怒风风控路由
 * @author chenyongkun
 * @date 2023/3/14
 */
@Data
public class StormRiskRouteParam {

    private static final long serialVersionUID = -5717171041737423594L;

    /**
     * 0 其它,1 星速台活动,2 普通活动
     */
    private Integer bizType;
    /**
     * 风控标签：60000自定义,60001 拉新,60002 促活,60003 留存,60004 积分消耗,60005 游戏,60006 秒杀
     */
    private Integer projectLabel;

    /**
     * 非星速台活动的活动类型
     */
    private Integer activityType;

    /**
     * 项目id:风控标签为 自定义时填写
     */
    private String projectId;

    /**
     * 兑吧应用id
     */
    private Long appId;

    /**
     * 风控主场景: 1 提现,2 参与,3 发奖
     */
    private Integer scene;

    /**
     * 页数
     */
    private Integer pageNo;
    /**
     * 每页记录数
     */
    private Integer pageSize;
}
