package cn.com.duiba.duiba.stormrage.center.common.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author chenyongkun
 * @date 2023/2/20
 */
@Data
public class EngineConditionDto implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 规则ID
     */
    private Long ruleId;

    /**
     * 字段id
     */
    private Long fieldId;

    /**
     * 操作符
     * ("操作符  " +
     *             ">：0数值型变量比较，\n" +
     *             "<：1数值型变量比较\n" +
     *             "=：2数值型或字符串型变量比较\n" +
     *             ">=：3数值型变量比较\n" +
     *             "<=：4数值型变量比较\n" +
     *             "≠：5数值型或字符串型变量比较\n" +
     *             ">and<=：6数值型变量比较\n" +
     *             ">and<：7数值型变量比较\n" +
     *             ">=and<：8数值型变量比较\n" +
     *             ">=and<=：9数值型变量比较\n" +
     *             "包含：10字符串型变量比较\n" +
     *             "不包含：11字符串型变量比较")
     */
    private Integer operation;

    /**
     * 阈值
     */
    private String threshold;

    /**
     * 创建者
     */
    private String creator;

    /**
     * 修改者
     */
    private String editor;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}
