package cn.com.duiba.duiba.stormrage.center.common.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author chenyongkun
 * @date 2023/2/20
 */
@Data
public class EngineRuleDto implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 策略id
     */
    private Long strategyId;

    /**
     * 父规则id
     */
    private Long parentRuleId;

    /**
     * 规则名字
     */
    private String ruleName;

    /**
     * 规则类型 (0=流程规则，1=评分规则）
     */
    private Integer ruleType;

    /**
     * 模式（0=全部满足，1=任意满足）
     */
    private Integer ruleMode;

    /**
     * 规则决策 （type=1时，为权重分）
     */
    private Double decision;

    /**
     * 状态 （0=启用，1=试运行，2=禁用）
     */
    private Integer ruleStatus;

    /**
     * 描述
     */
    private String description;

    /**
     * 条件
     */
    private List<EngineConditionDto> conditions;
//
//    /**
//     * 规则后置行为
//     */
//    private RuleAction ruleAction;
//
//    /**
//     * 拓展关联维度:1-rid,2-uuid6,3-deviceId,4-ua,5-ip
//     */
//    private Integer relateType;

    /**
     * 创建者
     */
    private String creator;

    /**
     * 修改者
     */
    private String editor;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}
