package cn.com.duiba.duixintong.center.api.dto.reference;

import cn.com.duiba.duixintong.center.api.enums.business.BankChannelEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhi
 * @date 2023/5/21 4:24 PM
 */
@Data
public class ReferenceRelatedDto implements Serializable {

    private static final long serialVersionUID = 5688451763252908799L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 推荐人用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 商家ID
     */
    private Long businessId;

    /**
     * 银行ID
     */
    private Long bankId;

    /**
     * 渠道：1-产险，2-车险，3-寿险，4-直销
     * @see BankChannelEnum
     */
    private Integer bankChannel;

    /**
     * 手机号
     */
    private String userPhone;

    /**
     * 推荐人等级
     */
    private Integer referenceLevel;

    /**
     * 推荐人上级推荐人用户ID，对应tb_users.id
     */
    private Long higherId;

    /**
     * 推荐人上级用户ID链路，以英文逗号分隔，从顶级到末级存储，不含自身用户ID
     */
    private String higherIds;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}
