package cn.com.duiba.duixintong.center.api.enums.order;

import cn.com.duiba.duixintong.center.api.utils.BitUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 订单分佣类型
 * @author lizhi
 * @date 2020/8/31 2:43 PM
 */
@AllArgsConstructor
@Getter
public enum OrderCommissionTypeEnum {
    REFERENCE(1, "推荐人"),
    BUSINESS(2, "商家"),
    IMPORTANT_CUSTOMER(3, "重客"),
    ;

    /**
     * 在二进制中的位置（从右往左第几位，从0开始）
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;
    
    private static final Map<Integer, OrderCommissionTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OrderCommissionTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static OrderCommissionTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    /**
     * 添加类型
     * @param type 所有类型十进制值
     * @param typeEnum 要添加的类型枚举
     * @return 添加后的所有类型十进制值
     */
    public static long addType(long type, OrderCommissionTypeEnum typeEnum) {
        if (typeEnum == null) {
            return type;
        }
        return BitUtils.addBit(type, typeEnum.getType() - 1);
    }

    /**
     * 查询数据库时需要的值
     * 查询：where commission_type & #{selectType} = #{selectType}
     * @return 查询数据库时需要的值
     */
    public long getSelectType() {
        return BitUtils.moveLeft1(type - 1);
    }
}
