package cn.com.duiba.duixintong.center.api.remoteservice.card;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duixintong.center.api.dto.card.BankCardOrderStatusRecordDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteBankCardOrderStatusRecordService {

    boolean save(BankCardOrderStatusRecordDto bankCardOrderStatusRecordDto);

    boolean updateById(BankCardOrderStatusRecordDto bankCardOrderStatusRecordDto);

    BankCardOrderStatusRecordDto getById(Long id);

    List<BankCardOrderStatusRecordDto> listByIds(List<Long> ids);

    BankCardOrderStatusRecordDto queryByOrderNumAndCardStatus(String orderNum, Integer cardStatus);

    /**
     * 根据订单号批量查询
     * @param orderNums 订单号集合
     * @return 订单状态详情
     */
    List<BankCardOrderStatusRecordDto> listByOrderNums(List<String> orderNums);
}
