package cn.com.duiba.geo.api;

import cn.com.duiba.geo.api.aop.GeoRemoteAspect;
import cn.com.duiba.geo.api.aop.GeoRemoteInterceptor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import javax.annotation.Resource;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass = true)
@EnableConfigurationProperties(GeoProperties.class)
public class GeoConfiguration{

    @Bean
    public GeoRemoteAspect geoRemoteAspect(){
        return new GeoRemoteAspect();
    }

    @Bean
    public GeoRemoteInterceptor geoRemoteInterceptor(){
        return new GeoRemoteInterceptor();
    }

    @Bean
    public GeoInterceptorConfiguration geoInterceptorConfiguration(){
        return new GeoInterceptorConfiguration();
    }

    @Configuration
    public static class GeoInterceptorConfiguration extends WebMvcConfigurerAdapter {

        @Resource
        private GeoRemoteInterceptor geoRemoteInterceptor;

        @Override
        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor(geoRemoteInterceptor)
                    .addPathPatterns("/**")
                    .excludePathPatterns("/monitor/check","/error");
        }
    }



}
