package cn.com.duiba.geo.api.aop;

import cn.com.duiba.geo.api.dto.IpAreaDto;
import com.alibaba.ttl.TransmittableThreadLocal;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;

@Aspect
public class GeoRemoteAspect {

    private TransmittableThreadLocal<GeoSession> geoSessionThreadLocal = new TransmittableThreadLocal<>();

    @Resource
    private ApplicationContext applicationContext;

    void createGeoSession(String uri){
        GeoSession session = new GeoSession();
        session.setUri(uri);
        geoSessionThreadLocal.set(session);
    }

    void clear(){
        geoSessionThreadLocal.remove();
    }

    @Around(value="execution(* cn.com.duiba.geo.api.remoteservice.RemoteIpAreaService.*(..)) && args(ip,..)")
    public IpAreaDto findIpArea(ProceedingJoinPoint joinPoint,String ip) throws Throwable {

        GeoSession session = geoSessionThreadLocal.get();
        if(Objects.isNull(session)){
            return (IpAreaDto) joinPoint.proceed();
        }

        if(session.containsKey(ip)){
            return session.getIpAreaDto(ip);
        }
        IpAreaDto ipAreaDto = (IpAreaDto) joinPoint.proceed();
        session.put(ip,ipAreaDto);
        applicationContext.publishEvent(ipAreaDto);//发布给各个GeoSessionInterceptor
        return ipAreaDto;
    }
}
